/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.core;

import com.allcam.acs.core.MD5;
import com.allcam.acs.http.HttpDigest;
import com.allcam.acs.utils.StringUtil;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcHttpDigest
implements HttpDigest {
    private static final Logger LOG = LoggerFactory.getLogger(AcHttpDigest.class);
    private static final String METHOD = "POST";
    private static final String REALM = "allcam";

    AcHttpDigest() {
    }

    @Override
    public String buildDigest(String un, String name, String password, String nonce, String opaque, String url) {
        if (StringUtils.isEmpty((CharSequence)opaque)) {
            opaque = RandomStringUtils.randomNumeric((int)16);
        }
        String nc = "00000001";
        String cnonce = "00000001";
        String response = this.generateResponse(name, REALM, nonce, url, "auth", nc, cnonce, password, null);
        StringBuilder sb = new StringBuilder();
        sb.append("Digest ").append(un).append("=").append(name).append(",realm=").append(REALM).append(", nonce =").append(nonce).append(",uri=").append(url).append(",response=").append(response).append(",cnonce=").append(cnonce).append(",opaque=").append(opaque).append(",qop=auth,nc=").append(nc);
        LOG.info("Digest: {}", (Object)sb.toString());
        return sb.toString();
    }

    private String generateResponse(String userName, String realm, String nonce, String url, String qop, String nc, String cnonce, String password, byte[] body) {
        return MD5.md5(StringUtil.appendStr(this.generateMD5(userName, realm, password), ":", this.generateSame(nonce, nc, cnonce, qop), ":", MD5.md5(this.firstA2(qop, url, body))));
    }

    private String generateMD5(String userName, String realm, String password) {
        return MD5.md5(this.generateA1(userName, realm, password));
    }

    private String generateSame(String nonce, String nc, String cnonce, String qop) {
        return StringUtil.appendStr(this.unq(nonce), ":", nc, ":", this.unq(cnonce), ":", this.unq(qop));
    }

    private String firstA2(String qop, String url, byte[] body) {
        if ("auth".equals(qop)) {
            return StringUtil.appendStr(METHOD, ":", url);
        }
        if ("auth-int".equals(qop)) {
            String entityBody;
            try {
                entityBody = new String(body, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                entityBody = new String(body);
            }
            return StringUtil.appendStr(METHOD, ":", url, ":", MD5.md5(entityBody));
        }
        return "";
    }

    private String generateA1(String userName, String realm, String password) {
        return StringUtil.appendStr(this.unq(userName), ":" + this.unq(realm), ":", this.unq(password));
    }

    private String unq(String value) {
        return value.replace("\"", "");
    }
}

