/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.json;

import com.allcam.acs.http.HttpService;
import com.allcam.acs.utils.JsonUtil;
import com.allcam.common.base.BaseRequest;
import com.allcam.common.base.BaseResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpJsonHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpJsonHandler.class);
    private HttpService httpService;

    public HttpJsonHandler(HttpService httpService) {
        this.httpService = httpService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends BaseResponse> T post(String apiUrl, BaseRequest reqBean, Class<T> respCls) {
        if (null == reqBean) {
            LOG.debug("doPost reqBean is null");
            return this.optErrorBean(2, "request bean is null.", respCls);
        }
        String jsonString = JsonUtil.toJson(reqBean);
        try (Response response = this.httpService.restHttp(apiUrl, jsonString);){
            String bodyStr;
            if (!response.isSuccessful()) {
                T t = this.optErrorBean(response.code(), "request fail.", respCls);
                return t;
            }
            ResponseBody respBody = response.body();
            String string = bodyStr = respBody == null ? null : respBody.string();
            if (StringUtils.isEmpty((CharSequence)bodyStr)) {
                LOG.error("Response Body is Empty.");
                T t = this.optErrorBean(2, "response body is empty.", respCls);
                return t;
            }
            LOG.debug("Response Body: {}", (Object)bodyStr);
            BaseResponse baseResponse = (BaseResponse)JsonUtil.fromJson(bodyStr, respCls);
            return (T)baseResponse;
        }
        catch (IOException e) {
            LOG.error("http post json fail.", (Throwable)e);
            if (!this.handleTimeout(e)) return this.optErrorBean(2, "http post json fail.", respCls);
            return this.optErrorBean(10, "http post time out.", respCls);
        }
    }

    private boolean handleTimeout(Throwable e) {
        if (null == e) {
            return false;
        }
        String errMsg = e.getMessage();
        if (e instanceof SocketException || e instanceof InterruptedIOException || null != errMsg && errMsg.toLowerCase().contains("timed out")) {
            LOG.debug("TIME_OUT");
            return true;
        }
        return false;
    }

    private <T extends BaseResponse> T optErrorBean(int code, String msg, Class<T> respCls) {
        try {
            BaseResponse respBean = (BaseResponse)respCls.newInstance();
            respBean.setResultCode(code);
            respBean.setResultDesc(msg);
            return (T)respBean;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("instance of response class fail.", (Throwable)e);
            return null;
        }
    }
}

