/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.http;

import com.allcam.acs.http.HttpAuthenticator;
import com.allcam.acs.http.HttpConfig;
import com.allcam.acs.http.HttpProgressCallback;
import com.allcam.acs.http.ProgressCallback;
import com.allcam.acs.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpService.class);
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json;charset=UTF-8");
    private OkHttpClient client;
    private HttpConfig httpConfig;

    public HttpService(HttpConfig config) {
        this.updateConfig(config);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)config.timeout, TimeUnit.SECONDS).writeTimeout((long)config.timeout, TimeUnit.SECONDS).readTimeout((long)(config.timeout * 2), TimeUnit.SECONDS).authenticator((Authenticator)new HttpAuthenticator(this.httpConfig)).retryOnConnectionFailure(true);
        if (null != this.httpConfig.sslSocketFactory) {
            builder.sslSocketFactory(this.httpConfig.sslSocketFactory);
        }
        if (null != this.httpConfig.hostnameVerifier) {
            builder.hostnameVerifier(this.httpConfig.hostnameVerifier);
        }
        this.client = builder.build();
    }

    public void updateConfig(HttpConfig config) {
        if (null == this.httpConfig) {
            this.httpConfig = config;
        } else {
            this.httpConfig.updateFrom(config);
        }
    }

    public boolean isAuthorized() {
        return null != this.httpConfig && !StringUtil.isEmpty(this.httpConfig.userName) && !StringUtil.isEmpty(this.httpConfig.password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String url) {
        LOG.error("url is: {}", (Object)url);
        if (!StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException("url is empty.");
        }
        Request request = new Request.Builder().url(url).addHeader("User-Agent", "allcam").get().build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) return "";
            ResponseBody body = response.body();
            String string = null == body ? "" : body.string();
            return string;
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        return "";
    }

    public Response postHttp(String jsonStr) throws IOException {
        return this.post(this.httpConfig.httpUrl, jsonStr);
    }

    public Response restHttp(String path, String jsonStr) throws IOException {
        return this.post(this.httpConfig.httpUrl + path, jsonStr);
    }

    public Response postHttps(String jsonStr) throws IOException {
        if (StringUtil.isEmpty(this.httpConfig.httpsUrl)) {
            return this.postHttp(jsonStr);
        }
        return this.post(this.httpConfig.httpsUrl, jsonStr);
    }

    public Response post(String url, String jsonStr) throws IOException {
        if (null == this.client) {
            LOG.error("http service not init.");
            throw new IllegalStateException("http service not init.");
        }
        if (null == jsonStr) {
            LOG.error("body is null");
            throw new IllegalArgumentException("http post body is null");
        }
        if (StringUtil.isEmpty(url)) {
            LOG.error("url is empty.");
            throw new IllegalArgumentException("url is empty.");
        }
        RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)jsonStr);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        LOG.info("post url[{}] \n and body[{}]", (Object)url, (Object)jsonStr);
        return this.client.newCall(request).execute();
    }

    public int upload(String url, String path, MediaType mediaType, HttpProgressCallback callback) {
        if (null == this.client) {
            LOG.error("http service not init.");
            return 2;
        }
        if (StringUtil.isEmpty(url)) {
            LOG.error("context or url is null");
            return 2;
        }
        if (StringUtil.isEmpty(path)) {
            LOG.error("path is empty");
            return 2;
        }
        File upFile = new File(path);
        ProgressRequestBody fileBody = new ProgressRequestBody(upFile, mediaType, callback);
        MultipartBody reqBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", upFile.getName(), (RequestBody)fileBody).build();
        Request request = new Request.Builder().url(url).post((RequestBody)reqBody).build();
        LOG.info("url is: {}", (Object)url);
        LOG.info("path is: {}", (Object)path);
        LOG.info("mediaType is: {}", (Object)mediaType);
        try {
            this.client.newCall(request).enqueue((Callback)callback);
            return 0;
        }
        catch (Exception e) {
            LOG.error("upload fail: ", (Throwable)e);
            return 2;
        }
    }

    private class ProgressRequestBody
    extends RequestBody {
        private static final int SEGMENT_SIZE = 2048;
        private File file;
        private MediaType mediaType;
        private long contentLength;
        private ProgressCallback callback;

        ProgressRequestBody(File file, MediaType mediaType, ProgressCallback callback) {
            this.file = file;
            this.mediaType = mediaType;
            this.contentLength = file.length();
            this.callback = callback;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public long contentLength() throws IOException {
            return this.contentLength;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            long read;
            Source source = Okio.source((File)this.file);
            for (long total = 0L; total < this.contentLength; total += read) {
                long remain = this.contentLength - total;
                long toRead = Math.min(remain, 2048L);
                read = source.read(sink.buffer(), toRead);
                if (read == -1L) break;
                sink.flush();
                if (this.callback == null) continue;
                this.callback.onProgress(total, this.contentLength);
            }
            source.close();
            this.callback = null;
        }
    }
}

