/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.core;

import com.allcam.acs.utils.StringUtil;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MD5 {
    private static final Logger LOG = LoggerFactory.getLogger(MD5.class);
    private static final String[] hexInts = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    MD5() {
    }

    public static String md5(String origin) {
        return MD5.byteArrayToHexString(MD5.compile(origin));
    }

    public static byte[] compile(String origin) {
        byte[] result = null;
        try {
            byte[] orgBytes = StringUtil.toString(origin).getBytes(Charset.forName("UTF-8"));
            MessageDigest md = MessageDigest.getInstance("MD5");
            result = md.digest(orgBytes);
        }
        catch (Exception ex) {
            LOG.error("compile fail.", (Throwable)ex);
        }
        return result;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        if (null == bytes) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (byte b : bytes) {
            buffer.append(MD5.byteToHexString(b));
        }
        return buffer.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexInts[d1] + hexInts[d2];
    }
}

