/*
 * Decompiled with CFR 0.152.
 */
package com.allcam.acs.core;

import org.apache.commons.lang3.StringUtils;

public class AcsConfig {
    private String host;
    private int port;
    private int httpTimeout;
    private String appId;
    private String appSecret;
    private String username;
    private String password;

    private AcsConfig() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getHttpTimeout() {
        return this.httpTimeout;
    }

    public void setHttpTimeout(int httpTimeout) {
        this.httpTimeout = httpTimeout;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private AcsConfig config = new AcsConfig();

        public AcsConfig build() {
            if (StringUtils.isBlank((CharSequence)this.config.host)) {
                this.config.host = "";
            }
            if (this.config.port == 0) {
                this.config.port = 10000;
            }
            if (this.config.httpTimeout == 0) {
                this.config.httpTimeout = 30;
            }
            return this.config;
        }

        public Builder host(String host) {
            this.config.host = host;
            return this;
        }

        public Builder port(int port) {
            this.config.port = port;
            return this;
        }

        public Builder httpTimeout(int timeout) {
            this.config.httpTimeout = timeout;
            return this;
        }

        public Builder appId(String appId) {
            this.config.appId = appId;
            return this;
        }

        public Builder appSecret(String appSecret) {
            this.config.appSecret = appSecret;
            return this;
        }

        public Builder username(String username) {
            this.config.username = username;
            return this;
        }

        public Builder password(String password) {
            this.config.password = password;
            return this;
        }
    }
}

