package com.allcam.common.base;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class Response extends AcBaseBean implements Result
{
    private static final long serialVersionUID = 3033423742590416485L;

    private int resultCode;

    private String resultDesc;

    public Response()
    {
        this.resultCode = ErrorCode.SUCCESS;
        this.resultDesc = "SUCCESS";
    }

    public Response(Response other)
    {
        this();
        if (null != other)
        {
            this.resultCode = other.resultCode;
            this.resultDesc = other.resultDesc;
        }
    }

    @Override
    @JsonIgnore
    public boolean isSuccess()
    {
        return getResultCode() == ErrorCode.SUCCESS;
    }

    @Override
    @JsonIgnore
    public int getError()
    {
        return getResultCode();
    }

    @Override
    @JsonIgnore
    public String requestResult()
    {
        return String.valueOf(getResultCode()).concat(":").concat(String.valueOf(getResultDesc()));
    }

    public int getResultCode()
    {
        return resultCode;
    }

    public void setResultCode(int resultCode)
    {
        this.resultCode = resultCode;
    }

    public String getResultDesc()
    {
        return resultDesc;
    }

    public void setResultDesc(String resultDesc)
    {
        this.resultDesc = resultDesc;
    }
}
