package com.allcam.common.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseResponse extends Response
{
    private static final Logger LOG = LoggerFactory.getLogger(BaseResponse.class);

    private static final long serialVersionUID = -1591428283706548092L;

    public BaseResponse()
    {
        super();
    }

    public BaseResponse(int resultCode)
    {
        this(resultCode, "error code: " + resultCode);
    }

    public BaseResponse(int resultCode, String resultMsg)
    {
        setResultCode(resultCode);
        setResultDesc(resultMsg);
    }

    public BaseResponse(Response response)
    {
        this(response.getResultCode(), response.getResultDesc());
        LOG.debug("build response from response[{}]", response);
    }
}
