package com.allcam.acs.utils;

public final class StringUtil
{

    public static int lengthOf(String str)
    {
        if (null == str)
        {
            return 0;
        }
        return str.length();
    }

    /**
     * 字符串是否为空或空字符串
     *
     * @param str 校验字符串
     * @return true:字符串为空或空字符串; false:字符串不是空字符串
     */
    public static boolean isEmpty(String str)
    {
        if (null == str || str.isEmpty())
        {
            return true;
        }

        str = str.trim();
        return (str.isEmpty() || "null".equals(str));
    }

    public static String appendStr(String... strings)
    {
        if (null == strings || strings.length == 0)
        {
            return "";
        }

        StringBuilder sb = new StringBuilder();
        for (String str : strings)
        {
            sb.append(toString(str));
        }
        return sb.toString();
    }

    public static String content(String str)
    {
        return isEmpty(str) ? "" : str;
    }

    public static String toString(String str)
    {
        return null == str ? "" : str;
    }

    public static String trim(String str)
    {
        return null == str ? "" : str.trim();
    }

    public static String convertExt(String str)
    {
        if (isEmpty(str))
        {
            return str;
        }

        if (str.endsWith("\\"))
        {
            str = str.concat(".");
        }
        return str;
    }

    public static String getValueFromUrl(String url, String key)
    {
        if (isEmpty(url) || isEmpty(key))
        {
            return null;
        }

        String value = null;
        if (url.contains(key))
        {
            value = url.substring(url.indexOf(key) + key.length());
            int index = value.indexOf('&');
            if (index > 0)
            {
                value = value.substring(0, index);
            }
        }
        return value;
    }

    public static String getValueFromHeader(String header, String key)
    {
        header = toString(header);
        key = toString(key);

        int pos1 = header.indexOf(key);
        String nonceStr = pos1 < 0 ? "" : header.substring(pos1 + key.length());
        int pos2 = nonceStr.indexOf(',');
        return (pos2 < 0 ? nonceStr : nonceStr.substring(0, pos2));
    }

    public static boolean equals(String left, String right)
    {
        return toString(left).equals(toString(right));
    }

    public static boolean equalsIgnoreCase(String left, String right)
    {
        return toString(left).equalsIgnoreCase(toString(right));
    }

    public static int compare(String lStr, String rStr)
    {
        return toString(lStr).compareTo(toString(rStr));
    }

}
