package com.allcam.acs.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;


/**
 * RYBAndroid
 * Created by Beowulf on 2015-08-06.
 */
public class SSLCustomSocketFactory
{
    private static final Logger LOG = LoggerFactory.getLogger(SSLCustomSocketFactory.class);

    public static final String KEY_PASS = "Allcam_https";

    public static SSLSocketFactory getSocketFactory(String certPath)
    {
        return getSocketFactory(certPath, KEY_PASS);
    }

    public static SSLSocketFactory getSocketFactory(String certPath, String keyPass)
    {
        try (InputStream ins = new FileInputStream(certPath))
        {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(ins, keyPass.toCharArray());

            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory =
                    TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());

            trustManagerFactory.init(trustStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Throwable e)
        {
            LOG.error("getSocketFactory fail: ", e);
        }
        return null;
    }
}
