package com.allcam.acs.http;

import org.apache.commons.lang3.StringUtils;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

/**
 * HttpConfig
 * Created by Beowulf on 2016-01-12.
 */
public class HttpConfig
{
    String un;
    String httpUrl;
    String httpsUrl;
    String userName;
    String password;
    int timeout;
    HttpDigest httpDigest;
    HostnameVerifier hostnameVerifier;
    SSLSocketFactory sslSocketFactory;

    private HttpConfig()
    {
    }

    void updateFrom(HttpConfig oConfig)
    {
        if (null != oConfig.un)
        {
            this.un = oConfig.un;
        }
        if (null != oConfig.httpUrl)
        {
            this.httpUrl = oConfig.httpUrl;
        }
        if (null != oConfig.httpsUrl)
        {
            this.httpsUrl = oConfig.httpsUrl;
        }
        if (null != oConfig.userName)
        {
            this.userName = oConfig.userName;
        }
        if (null != oConfig.password)
        {
            this.password = oConfig.password;
        }
        if (null != oConfig.httpDigest)
        {
            this.httpDigest = oConfig.httpDigest;
        }
        if (0 != oConfig.timeout)
        {
            this.timeout = oConfig.timeout;
        }
        if (null != oConfig.hostnameVerifier)
        {
            this.hostnameVerifier = oConfig.hostnameVerifier;
        }
        if (null != oConfig.sslSocketFactory)
        {
            this.sslSocketFactory = oConfig.sslSocketFactory;
        }
    }

    public static class Builder
    {
        private HttpConfig httpConfig;

        public Builder()
        {
            httpConfig = new HttpConfig();
        }

        public HttpConfig build()
        {
            if (StringUtils.isBlank(httpConfig.userName))
            {
                throw new IllegalArgumentException("auth account not config");
            }
            if (StringUtils.isBlank(httpConfig.password))
            {
                throw new IllegalArgumentException("auth password not config");
            }
            return httpConfig;
        }

        public Builder httpUrl(String httpUrl)
        {
            httpConfig.httpUrl = httpUrl;
            return this;
        }

        public Builder httpsUrl(String httpsUrl)
        {
            httpConfig.httpsUrl = httpsUrl;
            return this;
        }

        public Builder un(String un)
        {
            httpConfig.un = un;
            return this;
        }

        public Builder userName(String userName)
        {
            httpConfig.userName = userName;
            return this;
        }

        public Builder password(String password)
        {
            httpConfig.password = password;
            return this;
        }

        public Builder httpDigest(HttpDigest httpDigest)
        {
            httpConfig.httpDigest = httpDigest;
            return this;
        }

        public Builder timeout(int timeout)
        {
            httpConfig.timeout = timeout;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier)
        {
            httpConfig.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory)
        {
            httpConfig.sslSocketFactory = sslSocketFactory;
            return this;
        }
    }
}
