package com.allcam.acs.http;

import com.allcam.acs.utils.StringUtil;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

import java.io.IOException;

/**
 * RYBAndroid
 * Created by Beowulf on 2016-03-28.
 */
public class HttpAuthenticator implements Authenticator
{
    private HttpConfig httpConfig;

    HttpAuthenticator(HttpConfig httpConfig)
    {
        this.httpConfig = httpConfig;
    }

    @Override
    public Request authenticate(Route route, Response response)
        throws IOException
    {
        if (null == response || response.priorResponse() != null)
        {
            return null;
        }

        String authStr = response.header("WWW-Authenticate");
        String nonce = StringUtil.getValueFromHeader(authStr, "nonce=");
        String opaque = StringUtil.getValueFromHeader(authStr, "opaque=");

        Request lastReq = response.request();
        if (null == lastReq)
        {
            return null;
        }

        String url = lastReq.url().toString();
        return lastReq.newBuilder().header("Authorization",
            buildDigest(nonce, opaque, url)).build();
    }

    private String buildDigest(String nonce, String opaque, String url)
    {
        HttpDigest digest = httpConfig.httpDigest;
        if (null == digest)
        {
            return "";
        }
        return digest.buildDigest(httpConfig.un, httpConfig.userName, httpConfig.password, nonce, opaque, url);
    }
}
