package com.allcam.acs.core.api;

import com.allcam.acs.utils.XMLPaser;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiInit
{
    private static final Logger LOG = LoggerFactory.getLogger(ApiInit.class);

    private static final Map<String, FunctionInfo> FUNC_MAP = new HashMap<>();

    public static void initApiFromFile()
    {
        try
        {
            InputStream is = ApiInit.class.getResourceAsStream("/api.xml");
            String functionXml = IOUtils.toString(is, "UTF-8");

            FunctionConfigInfo config = XMLPaser.fromXml(functionXml, FunctionConfigInfo.class);
            List<FunctionInfo> functionList = config.getFunctionList();
            for (FunctionInfo functionInfo : functionList)
            {
                LOG.debug("save function: {}", functionInfo);
                FUNC_MAP.put(functionInfo.getReqClass(), functionInfo);
            }
        }
        catch (Exception e)
        {
            LOG.error("init function api fail", e);
        }

        LOG.info("init api from file Finish.");
    }

    public static FunctionInfo getFunctionInfo(String api)
    {
        return FUNC_MAP.get(api);
    }

}
