package com.allcam.acs.core;

import org.apache.commons.lang3.StringUtils;

public class AcsConfig
{
    private String host;

    private int port;

    private int httpTimeout;

    private String appId;

    private String appSecret;

    private String username;

    private String password;

    private AcsConfig()
    {
    }

    public String getHost()
    {
        return host;
    }

    public int getPort()
    {
        return port;
    }

    public int getHttpTimeout()
    {
        return httpTimeout;
    }

    public void setHttpTimeout(int httpTimeout)
    {
        this.httpTimeout = httpTimeout;
    }

    public String getAppId()
    {
        return appId;
    }

    public String getAppSecret()
    {
        return appSecret;
    }

    public String getUsername()
    {
        return username;
    }

    public String getPassword()
    {
        return password;
    }

    public static class Builder
    {
        private AcsConfig config;

        public Builder()
        {
            config = new AcsConfig();
        }

        public AcsConfig build()
        {
            if (StringUtils.isBlank(config.host))
            {
                config.host = "";
            }
            if (config.port == 0)
            {
                config.port = 10000;
            }
            if (config.httpTimeout == 0)
            {
                config.httpTimeout = 30;
            }
            return config;
        }

        public Builder host(String host)
        {
            config.host = host;
            return this;
        }

        public Builder port(int port)
        {
            config.port = port;
            return this;
        }

        public Builder httpTimeout(int timeout)
        {
            config.httpTimeout = timeout;
            return this;
        }

        public Builder appId(String appId)
        {
            config.appId = appId;
            return this;
        }

        public Builder appSecret(String appSecret)
        {
            config.appSecret = appSecret;
            return this;
        }

        public Builder username(String username)
        {
            config.username = username;
            return this;
        }

        public Builder password(String password)
        {
            config.password = password;
            return this;
        }
    }
}
