package com.allcam.acs.core;

import com.allcam.acs.http.HttpDigest;
import com.allcam.acs.utils.StringUtil;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;

class AcHttpDigest implements HttpDigest
{
    private static final Logger LOG = LoggerFactory.getLogger(AcHttpDigest.class);

    private static final String METHOD = "POST";

    private static final String REALM = "allcam";

    @Override
    public String buildDigest(String un, String name, String password, String nonce, String opaque, String url)
    {
        if (StringUtils.isEmpty(opaque))
        {
            opaque = RandomStringUtils.randomNumeric(16);
        }

        String nc = "00000001";
        String cnonce = "00000001";
        String response = generateResponse(name, REALM, nonce, url, "auth", nc, cnonce, password, null);
        StringBuilder sb = new StringBuilder();
        sb.append("Digest ").append(un).append("=").append(name)
            .append(",realm=").append(REALM).append(", nonce =").append(nonce).append(",uri=")
            .append(url).append(",response=").append(response).append(",cnonce=").append(cnonce)
            .append(",opaque=").append(opaque).append(",qop=auth,nc=").append(nc);

        LOG.info("Digest: {}", sb.toString());
        return sb.toString();
    }

    private String generateResponse(String userName, String realm, String nonce, String url, String qop,
        String nc, String cnonce, String password, byte[] body)
    {
        return MD5.md5(StringUtil.appendStr(generateMD5(userName, realm, password), ":",
            generateSame(nonce, nc, cnonce, qop), ":", MD5.md5(firstA2(qop, url, body))));
    }

    private String generateMD5(String userName, String realm, String password)
    {
        return MD5.md5(generateA1(userName, realm, password));
    }

    private String generateSame(String nonce, String nc, String cnonce, String qop)
    {
        return StringUtil.appendStr(unq(nonce), ":", nc, ":", unq(cnonce), ":", unq(qop));
    }

    private String firstA2(String qop, String url, byte[] body)
    {
        if ("auth".equals(qop))
        {
            return StringUtil.appendStr(METHOD, ":", url);
        }
        else if ("auth-int".equals(qop))
        {
            String entityBody;

            try
            {
                entityBody = new String(body, "utf-8");
            }
            catch (UnsupportedEncodingException e)
            {
                entityBody = new String(body);
            }

            return StringUtil.appendStr(METHOD, ":", url, ":", MD5.md5(entityBody));
        }

        return "";
    }

    private String generateA1(String userName, String realm, String password)
    {
        return StringUtil.appendStr(unq(userName), ":" + unq(realm), ":", unq(password));
    }

    private String unq(String value)
    {
        return value.replace("\"", "");
    }
}
