/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.connection;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.remoting.RemotingException;
import com.alipay.sofa.registry.server.meta.remoting.connection.NodeConnectManager;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionConnectionHandler
extends AbstractServerHandler
implements NodeConnectManager {
    private Map<String, InetSocketAddress> connections = new ConcurrentHashMap<String, InetSocketAddress>();

    @Override
    public void connected(Channel channel) throws RemotingException {
        super.connected(channel);
        this.addConnection(channel);
    }

    @Override
    public void disconnected(Channel channel) throws RemotingException {
        super.disconnected(channel);
        this.removeConnection(channel);
    }

    @Override
    public void addConnection(Channel channel) {
        InetSocketAddress remoteAddress = channel.getRemoteAddress();
        String connectId = NetUtil.toAddressString((InetSocketAddress)remoteAddress);
        this.connections.putIfAbsent(connectId, remoteAddress);
    }

    @Override
    public boolean removeConnection(Channel channel) {
        String connectId = NetUtil.toAddressString((InetSocketAddress)channel.getRemoteAddress());
        return this.connections.remove(connectId) != null;
    }

    @Override
    public Collection<InetSocketAddress> getConnections(String dataCenter) {
        return this.connections.values();
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.LISENTER;
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.SESSION;
    }
}

