/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionNodeExchanger.class);
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private MetaServerConfig metaServerConfig;

    public Response request(Request request) throws RequestException {
        Server sessionServer;
        Response response = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SessionNodeExchanger request body:{} url:{}", request.getRequestBody(), (Object)request.getRequestUrl());
        }
        if ((sessionServer = this.boltExchange.getServer(Integer.valueOf(this.metaServerConfig.getSessionServerPort()))) != null) {
            Channel channel = sessionServer.getChannel(request.getRequestUrl());
            if (channel != null && channel.isConnected()) {
                Object result = sessionServer.sendSync(channel, request.getRequestBody(), this.metaServerConfig.getSessionNodeExchangeTimeout());
                response = () -> result;
            } else {
                String errorMsg = "SessionNode Exchanger get channel error! channel with url:" + channel == null ? "" : channel.getRemoteAddress() + " can not be null or disconnected!";
                LOGGER.error(errorMsg);
                throw new RequestException(errorMsg, request);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SessionNodeExchanger response result:{} ", response.getResult());
        }
        return response;
    }

    public Client connectServer() {
        return null;
    }
}

