/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model.metaserver;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.consistency.hash.HashNode;

public class DataNode
implements Node,
HashNode {
    private final URL nodeUrl;
    private final String nodeName;
    private final String dataCenter;
    private String regionId;
    private Node.NodeStatus nodeStatus;
    private long registrationTimestamp;

    public DataNode(URL nodeUrl, String dataCenter) {
        this.nodeUrl = nodeUrl;
        this.nodeName = nodeUrl.getIpAddress();
        this.dataCenter = dataCenter;
        this.nodeStatus = Node.NodeStatus.INIT;
    }

    public DataNode(URL nodeUrl, String dataCenter, Node.NodeStatus status) {
        this(nodeUrl, dataCenter);
        this.nodeStatus = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataNode)) {
            return false;
        }
        DataNode that = (DataNode)o;
        if (this.nodeStatus != null ? !this.nodeStatus.equals((Object)that.nodeStatus) : that.nodeStatus != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.dataCenter != null ? !this.dataCenter.equals(that.dataCenter) : that.dataCenter != null) {
            return false;
        }
        if (this.regionId != null ? !this.regionId.equals(that.regionId) : that.regionId != null) {
            return false;
        }
        if (this.registrationTimestamp != that.registrationTimestamp) {
            return false;
        }
        return this.nodeUrl != null ? (this.nodeUrl.getAddressString() != null ? this.nodeUrl.getAddressString().equals(that.nodeUrl.getAddressString()) : that.nodeUrl.getAddressString() != null) : that.nodeUrl != null;
    }

    public int hashCode() {
        int result = this.nodeName != null ? this.nodeName.hashCode() : 0;
        result = 31 * result + (this.dataCenter != null ? this.dataCenter.hashCode() : 0);
        result = 31 * result + (this.regionId != null ? this.regionId.hashCode() : 0);
        result = 31 * result + (this.nodeStatus != null ? this.nodeStatus.hashCode() : 0);
        result = 31 * result + (int)(this.registrationTimestamp ^ this.registrationTimestamp >>> 32);
        result = 31 * result + (this.nodeUrl != null ? (this.nodeUrl.getAddressString() != null ? this.nodeUrl.getAddressString().hashCode() : 0) : 0);
        return result;
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.DATA;
    }

    @Override
    public URL getNodeUrl() {
        return this.nodeUrl;
    }

    public String getIp() {
        return this.nodeUrl == null ? "" : this.nodeUrl.getIpAddress();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    @Override
    public Node.NodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    @Override
    public void setNodeStatus(Node.NodeStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public long getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    public void setRegistrationTimestamp(long registrationTimestamp) {
        this.registrationTimestamp = registrationTimestamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataNode{");
        sb.append("ip=").append(this.getIp());
        sb.append(", dataCenter='").append(this.dataCenter).append('\'');
        sb.append(", regionId='").append(this.regionId).append('\'');
        sb.append(", nodeStatus=").append((Object)this.nodeStatus);
        sb.append(", registrationTimestamp=").append(this.registrationTimestamp);
        sb.append('}');
        return sb.toString();
    }
}

