/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactoryBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerAdapter;

public class LoggerSpaceFactory4Log4jBuilder
extends AbstractLoggerSpaceFactoryBuilder {
    public LoggerSpaceFactory4Log4jBuilder(SpaceId spaceId, SpaceInfo spaceInfo) {
        super(spaceId, spaceInfo);
    }

    @Override
    protected String getLoggingToolName() {
        return "log4j";
    }

    @Override
    public AbstractLoggerSpaceFactory doBuild(String spaceName, ClassLoader spaceClassloader, URL url) {
        try {
            Hierarchy repo = new Hierarchy((org.apache.log4j.Logger)new RootLogger(Level.WARN));
            DOMConfigurator domConfigurator = new DOMConfigurator();
            Field field = DOMConfigurator.class.getDeclaredField("props");
            field.setAccessible(true);
            field.set(domConfigurator, this.getProperties());
            domConfigurator.doConfigure(url, (LoggerRepository)repo);
            return new AbstractLoggerSpaceFactory(this.getLoggingToolName(), (LoggerRepository)repo){
                ConcurrentMap<String, Log4jLoggerAdapter> loggerMap;
                final /* synthetic */ LoggerRepository val$repo;
                {
                    this.val$repo = loggerRepository;
                    super(source);
                    this.loggerMap = new ConcurrentHashMap<String, Log4jLoggerAdapter>();
                }

                @Override
                public Logger setLevel(String loggerName, AdapterLevel adapterLevel) throws Exception {
                    Log4jLoggerAdapter log4jLoggerAdapter = (Log4jLoggerAdapter)this.getLogger(loggerName);
                    org.apache.log4j.Logger log4jLogger = this.val$repo.getLogger(loggerName);
                    Level log4jLevel = this.toLog4jLevel(adapterLevel);
                    log4jLogger.setLevel(log4jLevel);
                    return log4jLoggerAdapter;
                }

                public Logger getLogger(String name) {
                    Log4jLoggerAdapter log4jLoggerAdapter = (Log4jLoggerAdapter)this.loggerMap.get(name);
                    if (log4jLoggerAdapter != null) {
                        return log4jLoggerAdapter;
                    }
                    Log4jLoggerAdapter newInst = this.createSlf4jLogger(name);
                    Log4jLoggerAdapter oldInst = this.loggerMap.putIfAbsent(name, newInst);
                    return oldInst == null ? newInst : oldInst;
                }

                private Level toLog4jLevel(AdapterLevel adapterLevel) {
                    if (adapterLevel == null) {
                        throw new IllegalStateException("AdapterLevel is NULL when adapter to log4j.");
                    }
                    switch (adapterLevel) {
                        case TRACE: {
                            return Level.TRACE;
                        }
                        case DEBUG: {
                            return Level.DEBUG;
                        }
                        case INFO: {
                            return Level.INFO;
                        }
                        case WARN: {
                            return Level.WARN;
                        }
                        case ERROR: {
                            return Level.ERROR;
                        }
                    }
                    throw new IllegalStateException((Object)((Object)adapterLevel) + " is unknown when adapter to log4j.");
                }

                private Log4jLoggerAdapter createSlf4jLogger(String name) {
                    org.apache.log4j.Logger log4jLogger = this.val$repo.getLogger(name);
                    try {
                        Constructor constructor = Log4jLoggerAdapter.class.getDeclaredConstructor(org.apache.log4j.Logger.class);
                        constructor.setAccessible(true);
                        return (Log4jLoggerAdapter)constructor.newInstance(log4jLogger);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("get slf4j logger from  log4jLogger err!", e);
                    }
                }
            };
        }
        catch (Throwable e) {
            throw new IllegalStateException("Log4j loggerSpaceFactory build error!", e);
        }
    }
}

