/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.rpc.netty;

import com.alibaba.fescar.core.protocol.AbstractMessage;
import com.alibaba.fescar.core.protocol.HeartbeatMessage;
import com.alibaba.fescar.core.protocol.MessageCodec;
import com.alibaba.fescar.core.protocol.RpcMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.nio.ByteBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCodecHandler
extends ByteToMessageCodec<RpcMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageCodecHandler.class);
    private static short MAGIC = (short)-9510;
    private static int HEAD_LENGTH = 14;
    private static final int FLAG_REQUEST = 128;
    private static final int FLAG_ASYNC = 64;
    private static final int FLAG_HEARTBEAT = 32;
    private static final int FLAG_FESCAR_CODEC = 16;
    private static final int MAGIC_HALF = -38;
    private static final int NOT_FOUND_INDEX = -1;

    protected void encode(ChannelHandlerContext ctx, RpcMessage msg, ByteBuf out) throws Exception {
        MessageCodec msgCodec = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        if (msg.getBody() instanceof MessageCodec) {
            msgCodec = (MessageCodec)msg.getBody();
        }
        byteBuffer.putShort(MAGIC);
        int flag = (msg.isAsync() ? 64 : 0) | (msg.isHeartbeat() ? 32 : 0) | (msg.isRequest() ? 128 : 0) | (msgCodec != null ? 16 : 0);
        byteBuffer.putShort((short)flag);
        if (msg.getBody() instanceof HeartbeatMessage) {
            byteBuffer.putShort((short)0);
            byteBuffer.putLong(msg.getId());
            byteBuffer.flip();
            byte[] content = new byte[byteBuffer.limit()];
            byteBuffer.get(content);
            out.writeBytes(content);
            return;
        }
        try {
            if (null != msgCodec) {
                byteBuffer.putShort(msgCodec.getTypeCode());
                byteBuffer.putLong(msg.getId());
                byteBuffer.flip();
                byte[] content = new byte[byteBuffer.limit()];
                byteBuffer.get(content);
                out.writeBytes(content);
                out.writeBytes(msgCodec.encode());
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("msg:" + msg.getBody().toString());
                }
                byte[] body = MessageCodecHandler.hessianSerialize(msg.getBody());
                byteBuffer.putShort((short)body.length);
                byteBuffer.putLong(msg.getId());
                byteBuffer.put(body);
                byteBuffer.flip();
                byte[] content = new byte[byteBuffer.limit()];
                byteBuffer.get(content);
                out.writeBytes(content);
            }
        }
        catch (Exception e) {
            LOGGER.error(msg.getBody() + " encode error", (Object)"", (Object)e);
            throw e;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Send:" + msg.getBody());
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int begin = in.readerIndex();
        int magicIndex = MessageCodecHandler.getMagicIndex(in);
        if (magicIndex == -1) {
            LOGGER.error("codec decode not found magic offset");
            in.skipBytes(in.readableBytes());
            return;
        }
        if (magicIndex != 0 && LOGGER.isInfoEnabled()) {
            LOGGER.info("please notice magicIndex is not zero offset!!!");
        }
        in.skipBytes(magicIndex - in.readerIndex());
        if (in.readableBytes() < HEAD_LENGTH) {
            LOGGER.error("decode less than header length");
            return;
        }
        byte[] buffer = new byte[HEAD_LENGTH];
        in.readBytes(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        short magic = byteBuffer.getShort();
        if (magic != MAGIC) {
            LOGGER.error("decode error,will close channel:" + ctx.channel());
            ctx.channel().close();
            return;
        }
        short flag = byteBuffer.getShort();
        boolean isHeartbeat = (0x20 & flag) > 0;
        boolean isRequest = (0x80 & flag) > 0;
        boolean isFescarCodec = (0x10 & flag) > 0;
        short bodyLength = 0;
        short typeCode = 0;
        if (!isFescarCodec) {
            bodyLength = byteBuffer.getShort();
        } else {
            typeCode = byteBuffer.getShort();
        }
        long msgId = byteBuffer.getLong();
        if (isHeartbeat) {
            RpcMessage rpcMessage = new RpcMessage();
            rpcMessage.setId(msgId);
            rpcMessage.setAsync(true);
            rpcMessage.setHeartbeat(isHeartbeat);
            rpcMessage.setRequest(isRequest);
            if (isRequest) {
                rpcMessage.setBody(HeartbeatMessage.PING);
            } else {
                rpcMessage.setBody(HeartbeatMessage.PONG);
            }
            out.add(rpcMessage);
            return;
        }
        if (bodyLength > 0 && in.readableBytes() < bodyLength) {
            in.readerIndex(begin);
            return;
        }
        RpcMessage rpcMessage = new RpcMessage();
        rpcMessage.setId(msgId);
        rpcMessage.setAsync((0x40 & flag) > 0);
        rpcMessage.setHeartbeat(false);
        rpcMessage.setRequest(isRequest);
        try {
            if (isFescarCodec) {
                MessageCodec msgCodec = AbstractMessage.getMsgInstanceByCode(typeCode);
                if (!msgCodec.decode(in)) {
                    LOGGER.error(msgCodec + " decode error.");
                    in.readerIndex(begin);
                    return;
                }
                rpcMessage.setBody(msgCodec);
            } else {
                byte[] body = new byte[bodyLength];
                in.readBytes(body);
                Object bodyObject = MessageCodecHandler.hessianDeserialize(body);
                rpcMessage.setBody(bodyObject);
            }
        }
        catch (Exception e) {
            LOGGER.error("decode error", (Object)"", (Object)e);
            throw e;
        }
        out.add(rpcMessage);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receive:" + rpcMessage.getBody() + ",messageId:" + msgId);
        }
    }

    private static byte[] hessianSerialize(Object object) throws Exception {
        if (object == null) {
            throw new NullPointerException();
        }
        throw new RuntimeException("hessianSerialize not support");
    }

    private static Object hessianDeserialize(byte[] bytes) throws Exception {
        if (bytes == null) {
            throw new NullPointerException();
        }
        throw new RuntimeException("hessianDeserialize not support");
    }

    private static int getMagicIndex(ByteBuf in) {
        boolean found = false;
        int begin = 0;
        for (int readIndex = in.readerIndex(); readIndex < in.writerIndex(); ++readIndex) {
            if (in.getByte(readIndex) != -38 || in.getByte(readIndex + 1) != -38) continue;
            begin = readIndex;
            found = true;
            break;
        }
        return found ? begin : -1;
    }
}

