/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.rpc.netty;

import com.alibaba.fescar.common.XID;
import com.alibaba.fescar.common.thread.NamedThreadFactory;
import com.alibaba.fescar.core.rpc.RemotingServer;
import com.alibaba.fescar.core.rpc.netty.AbstractRpcRemoting;
import com.alibaba.fescar.core.rpc.netty.MessageCodecHandler;
import com.alibaba.fescar.core.rpc.netty.NettyServerConfig;
import com.alibaba.fescar.discovery.registry.RegistryFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRpcRemotingServer
extends AbstractRpcRemoting
implements RemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRpcRemotingServer.class);
    private final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final EventLoopGroup eventLoopGroupBoss;
    private final NettyServerConfig nettyServerConfig;
    private int listenPort;

    public void setListenPort(int listenPort) {
        if (listenPort <= 0) {
            throw new IllegalArgumentException("listen port: " + listenPort + " is invalid!");
        }
        this.listenPort = listenPort;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public AbstractRpcRemotingServer(NettyServerConfig nettyServerConfig) {
        this(nettyServerConfig, null, new ChannelHandler[0]);
    }

    public AbstractRpcRemotingServer(NettyServerConfig nettyServerConfig, ThreadPoolExecutor messageExecutor, ChannelHandler ... handlers) {
        super(messageExecutor);
        this.nettyServerConfig = nettyServerConfig;
        if (NettyServerConfig.enableEpoll()) {
            this.eventLoopGroupBoss = new EpollEventLoopGroup(nettyServerConfig.getBossThreadSize(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getBossThreadPrefix(), nettyServerConfig.getBossThreadSize()));
            this.eventLoopGroupWorker = new EpollEventLoopGroup(nettyServerConfig.getServerWorkerThreads(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getWorkerThreadPrefix(), nettyServerConfig.getServerWorkerThreads()));
        } else {
            this.eventLoopGroupBoss = new NioEventLoopGroup(nettyServerConfig.getBossThreadSize(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getBossThreadPrefix(), nettyServerConfig.getBossThreadSize()));
            this.eventLoopGroupWorker = new NioEventLoopGroup(nettyServerConfig.getServerWorkerThreads(), (ThreadFactory)new NamedThreadFactory(nettyServerConfig.getWorkerThreadPrefix(), nettyServerConfig.getServerWorkerThreads()));
        }
        if (null != handlers) {
            this.channelHandlers = handlers;
        }
        this.setListenPort(nettyServerConfig.getDefaultListenPort());
    }

    @Override
    public void start() {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupWorker).channel(this.nettyServerConfig.SERVER_CHANNEL_CLAZZ)).option(ChannelOption.SO_BACKLOG, (Object)this.nettyServerConfig.getSoBackLogSize())).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)this.nettyServerConfig.getServerSocketSendBufSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.nettyServerConfig.getServerSocketResvBufSize()).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyServerConfig.getWriteBufferLowWaterMark(), this.nettyServerConfig.getWriteBufferHighWaterMark())).localAddress((SocketAddress)new InetSocketAddress(this.listenPort))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(AbstractRpcRemotingServer.this.nettyServerConfig.getChannelMaxReadIdleSeconds(), 0, 0)}).addLast(new ChannelHandler[]{new MessageCodecHandler()});
                if (null != AbstractRpcRemotingServer.this.channelHandlers) {
                    AbstractRpcRemotingServer.this.addChannelPipelineLast((Channel)ch, AbstractRpcRemotingServer.this.channelHandlers);
                }
            }
        });
        if (this.nettyServerConfig.isEnableServerPooledByteBufAllocator()) {
            this.serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)NettyServerConfig.DIRECT_BYTE_BUF_ALLOCATOR);
        }
        try {
            ChannelFuture future = this.serverBootstrap.bind(this.listenPort).sync();
            LOGGER.info("Server started ... ");
            RegistryFactory.getInstance().register(new InetSocketAddress(XID.getIpAddress(), XID.getPort()));
            this.registerShutdownHook();
            future.channel().closeFuture().sync();
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown()));
    }

    @Override
    public void shutdown() {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Shuting server down. ");
            }
            RegistryFactory.getInstance().unregister(new InetSocketAddress(XID.getIpAddress(), XID.getPort()));
            TimeUnit.SECONDS.sleep(this.nettyServerConfig.getServerShutdownWaitTime());
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupWorker.shutdownGracefully();
        }
        catch (Exception exx) {
            LOGGER.error(exx.getMessage());
        }
    }

    @Override
    public void destroyChannel(String serverAddress, Channel channel) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will destroy channel:" + channel + ",address:" + serverAddress);
        }
        channel.disconnect();
        channel.close();
    }
}

