/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.registry.Registry;
import com.alibaba.dubbo.registry.RegistryFactory;
import com.alibaba.dubbo.registry.RegistryService;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegistryFactory
implements RegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegistryFactory.class);
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<String, Registry> REGISTRIES = new ConcurrentHashMap<String, Registry>();

    public static Collection<Registry> getRegistries() {
        return Collections.unmodifiableCollection(REGISTRIES.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAll() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Close all registries " + AbstractRegistryFactory.getRegistries());
        }
        LOCK.lock();
        try {
            for (Registry registry : AbstractRegistryFactory.getRegistries()) {
                try {
                    registry.destroy();
                }
                catch (Throwable e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
            REGISTRIES.clear();
            Object var4_3 = null;
            LOCK.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            LOCK.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registry getRegistry(URL url) {
        Registry registry;
        String key;
        block4: {
            url = url.setPath(RegistryService.class.getName()).addParameter("interface", RegistryService.class.getName()).removeParameters("export", "refer");
            key = url.toServiceString();
            LOCK.lock();
            try {
                registry = REGISTRIES.get(key);
                if (registry == null) break block4;
                Registry registry2 = registry;
                Object var6_6 = null;
                LOCK.unlock();
                return registry2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                LOCK.unlock();
                throw throwable;
            }
        }
        registry = this.createRegistry(url);
        if (registry == null) {
            throw new IllegalStateException("Can not create registry " + url);
        }
        REGISTRIES.put(key, registry);
        Registry registry3 = registry;
        Object var6_7 = null;
        LOCK.unlock();
        return registry3;
    }

    protected abstract Registry createRegistry(URL var1);
}

