/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class SpiLoader {
    private static final Map<String, ServiceLoader> SERVICE_LOADER_MAP = new ConcurrentHashMap<String, ServiceLoader>();

    public static <T> T loadFirstInstance(Class<T> clazz) {
        try {
            Iterator iterator;
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoader.load(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            if ((iterator = serviceLoader.iterator()).hasNext()) {
                return (T)iterator.next();
            }
            return null;
        }
        catch (Throwable t) {
            RecordLog.warn("[SpiLoader] ERROR: loadFirstInstance failed", t);
            t.printStackTrace();
            return null;
        }
    }

    public static <T> T loadHighestPriorityInstance(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoader.load(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            SpiOrderWrapper<T> w = null;
            for (T spi : serviceLoader) {
                int order = SpiOrderResolver.resolveOrder(spi);
                RecordLog.info("[SpiLoader] Found {0} SPI: {1} with order " + order, clazz.getSimpleName(), spi.getClass().getCanonicalName());
                if (w != null && order >= ((SpiOrderWrapper)w).order) continue;
                w = new SpiOrderWrapper<T>(order, spi);
            }
            return (T)(w == null ? null : ((SpiOrderWrapper)w).spi);
        }
        catch (Throwable t) {
            RecordLog.warn("[SpiLoader] ERROR: loadHighestPriorityInstance failed", t);
            t.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> loadInstanceList(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoader.load(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            ArrayList<T> list = new ArrayList<T>();
            for (T spi : serviceLoader) {
                list.add(spi);
            }
            return list;
        }
        catch (Throwable t) {
            RecordLog.warn("[SpiLoader] ERROR: loadInstanceListSorted failed", t);
            t.printStackTrace();
            return new ArrayList();
        }
    }

    public static <T> List<T> loadInstanceListSorted(Class<T> clazz) {
        try {
            String key = clazz.getName();
            ServiceLoader<T> serviceLoader = SERVICE_LOADER_MAP.get(key);
            if (serviceLoader == null) {
                serviceLoader = ServiceLoader.load(clazz);
                SERVICE_LOADER_MAP.put(key, serviceLoader);
            }
            ArrayList orderWrappers = new ArrayList();
            for (T spi : serviceLoader) {
                int order = SpiOrderResolver.resolveOrder(spi);
                SpiOrderResolver.insertSorted(orderWrappers, spi, order);
                RecordLog.info("[SpiLoader] Found {0} SPI: {1} with order " + order, clazz.getSimpleName(), spi.getClass().getCanonicalName());
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < orderWrappers.size(); ++i) {
                list.add(i, ((SpiOrderWrapper)orderWrappers.get(i)).spi);
            }
            return list;
        }
        catch (Throwable t) {
            RecordLog.warn("[SpiLoader] ERROR: loadInstanceListSorted failed", t);
            t.printStackTrace();
            return new ArrayList();
        }
    }

    private SpiLoader() {
    }

    private static class SpiOrderWrapper<T> {
        private final int order;
        private final T spi;

        SpiOrderWrapper(int order, T spi) {
            this.order = order;
            this.spi = spi;
        }

        int getOrder() {
            return this.order;
        }

        T getSpi() {
            return this.spi;
        }
    }

    private static class SpiOrderResolver {
        private SpiOrderResolver() {
        }

        private static <T> void insertSorted(List<SpiOrderWrapper<T>> list, T spi, int order) {
            int idx;
            for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
            }
            list.add(idx, new SpiOrderWrapper<T>(order, spi));
        }

        private static <T> int resolveOrder(T spi) {
            if (!spi.getClass().isAnnotationPresent(SpiOrder.class)) {
                return Integer.MAX_VALUE;
            }
            return spi.getClass().getAnnotation(SpiOrder.class).value();
        }
    }
}

