/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.node.IntervalProperty;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.OccupyTimeoutProperty;
import com.alibaba.csp.sentinel.node.SampleCountProperty;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.slots.statistic.metric.ArrayMetric;
import com.alibaba.csp.sentinel.slots.statistic.metric.Metric;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StatisticNode
implements Node {
    private volatile transient Metric rollingCounterInSecond = new ArrayMetric(SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
    private transient Metric rollingCounterInMinute = new ArrayMetric(60, 60000, false);
    private AtomicInteger curThreadNum = new AtomicInteger(0);
    private long lastFetchTime = -1L;

    @Override
    public Map<Long, MetricNode> metrics() {
        long currentTime = TimeUtil.currentTimeMillis();
        currentTime -= currentTime % 1000L;
        ConcurrentHashMap<Long, MetricNode> metrics = new ConcurrentHashMap<Long, MetricNode>();
        List<MetricNode> nodesOfEverySecond = this.rollingCounterInMinute.details();
        long newLastFetchTime = this.lastFetchTime;
        for (MetricNode node : nodesOfEverySecond) {
            if (!this.isNodeInTime(node, currentTime) || !this.isValidMetricNode(node)) continue;
            metrics.put(node.getTimestamp(), node);
            newLastFetchTime = Math.max(newLastFetchTime, node.getTimestamp());
        }
        this.lastFetchTime = newLastFetchTime;
        return metrics;
    }

    private boolean isNodeInTime(MetricNode node, long currentTime) {
        return node.getTimestamp() > this.lastFetchTime && node.getTimestamp() < currentTime;
    }

    private boolean isValidMetricNode(MetricNode node) {
        return node.getPassQps() > 0L || node.getBlockQps() > 0L || node.getSuccessQps() > 0L || node.getExceptionQps() > 0L || node.getRt() > 0L || node.getOccupiedPassQps() > 0L;
    }

    @Override
    public void reset() {
        this.rollingCounterInSecond = new ArrayMetric(SampleCountProperty.SAMPLE_COUNT, IntervalProperty.INTERVAL);
    }

    @Override
    public long totalRequest() {
        long totalRequest = this.rollingCounterInMinute.pass() + this.rollingCounterInMinute.block();
        return totalRequest;
    }

    @Override
    public long blockRequest() {
        return this.rollingCounterInMinute.block();
    }

    @Override
    public double blockQps() {
        return (double)this.rollingCounterInSecond.block() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double previousBlockQps() {
        return this.rollingCounterInMinute.previousWindowBlock();
    }

    @Override
    public double previousPassQps() {
        return this.rollingCounterInMinute.previousWindowPass();
    }

    @Override
    public double totalQps() {
        return this.passQps() + this.blockQps();
    }

    @Override
    public long totalSuccess() {
        return this.rollingCounterInMinute.success();
    }

    @Override
    public double exceptionQps() {
        return (double)this.rollingCounterInSecond.exception() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public long totalException() {
        return this.rollingCounterInMinute.exception();
    }

    @Override
    public double passQps() {
        return (double)this.rollingCounterInSecond.pass() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public long totalPass() {
        return this.rollingCounterInMinute.pass();
    }

    @Override
    public double successQps() {
        return (double)this.rollingCounterInSecond.success() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double maxSuccessQps() {
        return this.rollingCounterInSecond.maxSuccess() * (long)this.rollingCounterInSecond.getSampleCount();
    }

    @Override
    public double occupiedPassQps() {
        return (double)this.rollingCounterInSecond.occupiedPass() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double avgRt() {
        long successCount = this.rollingCounterInSecond.success();
        if (successCount == 0L) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.rt() * 1.0 / (double)successCount;
    }

    @Override
    public double minRt() {
        return this.rollingCounterInSecond.minRt();
    }

    @Override
    public int curThreadNum() {
        return this.curThreadNum.get();
    }

    @Override
    public void addPassRequest(int count) {
        this.rollingCounterInSecond.addPass(count);
        this.rollingCounterInMinute.addPass(count);
    }

    @Override
    public void addRtAndSuccess(long rt, int successCount) {
        this.rollingCounterInSecond.addSuccess(successCount);
        this.rollingCounterInSecond.addRT(rt);
        this.rollingCounterInMinute.addSuccess(successCount);
        this.rollingCounterInMinute.addRT(rt);
    }

    @Override
    public void increaseBlockQps(int count) {
        this.rollingCounterInSecond.addBlock(count);
        this.rollingCounterInMinute.addBlock(count);
    }

    @Override
    public void increaseExceptionQps(int count) {
        this.rollingCounterInSecond.addException(count);
        this.rollingCounterInMinute.addException(count);
    }

    @Override
    public void increaseThreadNum() {
        this.curThreadNum.incrementAndGet();
    }

    @Override
    public void decreaseThreadNum() {
        this.curThreadNum.decrementAndGet();
    }

    @Override
    public void debug() {
        this.rollingCounterInSecond.debug();
    }

    @Override
    public long tryOccupyNext(long currentTime, int acquireCount, double threshold) {
        long waitInMs;
        double maxCount = threshold * (double)IntervalProperty.INTERVAL / 1000.0;
        long currentBorrow = this.rollingCounterInSecond.waiting();
        if ((double)currentBorrow >= maxCount) {
            return OccupyTimeoutProperty.getOccupyTimeout();
        }
        int windowLength = IntervalProperty.INTERVAL / SampleCountProperty.SAMPLE_COUNT;
        long earliestTime = currentTime - currentTime % (long)windowLength + (long)windowLength - (long)IntervalProperty.INTERVAL;
        int idx = 0;
        long currentPass = this.rollingCounterInSecond.pass();
        while (earliestTime < currentTime && (waitInMs = (long)(idx * windowLength + windowLength) - currentTime % (long)windowLength) < (long)OccupyTimeoutProperty.getOccupyTimeout()) {
            long windowPass = this.rollingCounterInSecond.getWindowPass(earliestTime);
            if ((double)(currentPass + currentBorrow + (long)acquireCount - windowPass) <= maxCount) {
                return waitInMs;
            }
            earliestTime += (long)windowLength;
            currentPass -= windowPass;
            ++idx;
        }
        return OccupyTimeoutProperty.getOccupyTimeout();
    }

    @Override
    public long waiting() {
        return this.rollingCounterInSecond.waiting();
    }

    @Override
    public void addWaitingRequest(long futureTime, int acquireCount) {
        this.rollingCounterInSecond.addWaiting(futureTime, acquireCount);
    }

    @Override
    public void addOccupiedPass(int acquireCount) {
        this.rollingCounterInMinute.addOccupiedPass(acquireCount);
        this.rollingCounterInMinute.addPass(acquireCount);
    }
}

