/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.servlet;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.WebxComponents;
import com.alibaba.citrus.webx.WebxRootController;
import com.alibaba.citrus.webx.config.WebxConfiguration;
import com.alibaba.citrus.webx.context.WebxComponentsContext;
import com.alibaba.citrus.webx.servlet.FilterBean;
import com.alibaba.citrus.webx.servlet.PassThruSupportable;
import com.alibaba.citrus.webx.util.RequestURIFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebxFrameworkFilter
extends FilterBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String parentContextAttribute;
    private WebxComponents components;
    private RequestURIFilter excludeFilter;
    private RequestURIFilter passthruFilter;
    private String internalPathPrefix;

    public final String getParentContextAttribute() {
        return this.parentContextAttribute;
    }

    public final void setParentContextAttribute(String parentContextAttribute) {
        this.parentContextAttribute = StringUtil.trimToNull(parentContextAttribute);
    }

    public void setExcludes(String excludes) {
        this.excludeFilter = new RequestURIFilter(excludes);
    }

    public void setPassthru(String passthru) {
        this.passthruFilter = new RequestURIFilter(passthru);
    }

    public WebxComponents getWebxComponents() {
        return this.components;
    }

    @Override
    protected final void init() throws Exception {
        WebApplicationContext parentContext = this.findParentContext();
        if (parentContext instanceof WebxComponentsContext) {
            this.components = ((WebxComponentsContext)parentContext).getWebxComponents();
            WebxConfiguration configuration = this.components.getParentWebxConfiguration();
            if (configuration != null) {
                this.internalPathPrefix = configuration.getInternalPathPrefix();
                this.internalPathPrefix = FileUtil.normalizeAbsolutePath(this.internalPathPrefix, true);
            }
        }
        WebxRootController rootController = this.components.getWebxRootController();
        if (this.passthruFilter != null) {
            if (rootController instanceof PassThruSupportable) {
                ((PassThruSupportable)((Object)rootController)).setPassthruFilter(this.passthruFilter);
            } else {
                this.log.warn("You have specified Passthru Filter in /WEB-INF/web.xml.  It will not take effect because the implementation of WebxRootController ({}) does not support this feature.", (Object)rootController.getClass().getName());
            }
        }
    }

    private WebApplicationContext findParentContext() {
        WebApplicationContext parentContext = null;
        String parentContextAttribute = this.getParentContextAttribute();
        if (parentContextAttribute == null) {
            parentContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        } else {
            parentContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext(), (String)parentContextAttribute);
            Assert.assertNotNull(parentContext, "No WebApplicationContext \"%s\" found: not registered?", parentContextAttribute);
        }
        return parentContext;
    }

    protected void initFrameworkFilter() {
    }

    @Override
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isExcluded(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            this.getWebxComponents().getWebxRootController().service(request, response, chain);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    boolean isExcluded(HttpServletRequest request) {
        return this.excludeFilter != null && this.excludeFilter.matches(request) && !this.isInternalRequest(request);
    }

    private boolean isInternalRequest(HttpServletRequest request) {
        if (this.internalPathPrefix == null) {
            return false;
        }
        String path = request.getRequestURI();
        if (path.equals(this.internalPathPrefix)) {
            return true;
        }
        return path.startsWith(this.internalPathPrefix) && path.charAt(this.internalPathPrefix.length()) == '/';
    }
}

