/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.io;

import com.alibaba.citrus.util.io.OutputEngine;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class ReaderOutputEngine
implements OutputEngine {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private Reader reader;
    private String encoding;
    private OutputEngine.OutputStreamFactory factory;
    private char[] buffer;
    private Writer writer;

    public ReaderOutputEngine(Reader reader) {
        this(reader, null, null, 8192);
    }

    public ReaderOutputEngine(Reader reader, OutputEngine.OutputStreamFactory factory) {
        this(reader, factory, null, 8192);
    }

    public ReaderOutputEngine(Reader reader, OutputEngine.OutputStreamFactory factory, String encoding) {
        this(reader, factory, encoding, 8192);
    }

    public ReaderOutputEngine(Reader reader, OutputEngine.OutputStreamFactory factory, String encoding, int bufferSize) {
        this.reader = reader;
        this.encoding = encoding;
        this.factory = factory == null ? DEFAULT_OUTPUT_STREAM_FACTORY : factory;
        this.buffer = new char[bufferSize];
    }

    @Override
    public void open(OutputStream out) throws IOException {
        if (this.writer != null) {
            throw new IOException("Already initialized");
        }
        this.writer = this.encoding == null ? new OutputStreamWriter(this.factory.getOutputStream(out)) : new OutputStreamWriter(this.factory.getOutputStream(out), this.encoding);
    }

    @Override
    public void execute() throws IOException {
        if (this.writer == null) {
            throw new IOException("Not yet initialized");
        }
        int amount = this.reader.read(this.buffer);
        if (amount < 0) {
            this.writer.close();
        } else {
            this.writer.write(this.buffer, 0, amount);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

