/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.PipelineException;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.service.requestcontext.buffered.BufferedRequestContext;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import com.alibaba.citrus.util.regex.Substitution;
import com.alibaba.citrus.webx.ResourceNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Element;

public class GetResourceValve
extends AbstractValve
implements ResourceLoaderAware {
    private static final String DEFAULT_SUBSTITUTION_NAME = "subst";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private BufferedRequestContext bufferedRequestContext;
    private ResourceLoader loader;
    private String substName;
    private String resourceName;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.loader = resourceLoader;
    }

    public void setSubst(String substName) {
        this.substName = StringUtil.trimToNull(substName);
    }

    public void setName(String resourceName) {
        this.resourceName = StringUtil.trimToNull(resourceName);
    }

    @Override
    protected void init() throws Exception {
        this.substName = ObjectUtil.defaultIfNull(this.substName, DEFAULT_SUBSTITUTION_NAME);
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        Substitution subst = this.getSubstitution(pipelineContext);
        String resourceName = subst != null && this.resourceName != null ? StringUtil.trimToNull(subst.substitute(this.resourceName)) : ServletUtil.getResourcePath(rundata.getRequest());
        try {
            resourceName = URI.create(resourceName).normalize().toString();
            if (resourceName.contains("../")) {
                resourceName = null;
            }
        }
        catch (IllegalArgumentException e) {
            resourceName = null;
        }
        Resource resource = null;
        if (resourceName != null) {
            resource = this.loader.getResource(resourceName);
        }
        if (resource == null || !resource.exists()) {
            throw new ResourceNotFoundException("Could not find resource: " + resourceName);
        }
        InputStream istream = null;
        OutputStream ostream = null;
        try {
            URLConnection connection = resource.getURL().openConnection();
            String contentType = connection.getContentType();
            if (contentType != null) {
                rundata.getResponse().setContentType(contentType);
            }
            istream = connection.getInputStream();
            this.bufferedRequestContext.setBuffering(false);
            ostream = rundata.getResponse().getOutputStream();
            StreamUtil.io(istream, ostream, true, false);
        }
        catch (IOException e) {
            throw new PipelineException("Failed reading resource: " + resource);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.flush();
                }
                catch (IOException e) {}
            }
        }
        pipelineContext.invokeNext();
    }

    private Substitution getSubstitution(PipelineContext pipelineContext) {
        return (Substitution)pipelineContext.getAttribute(this.substName);
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<GetResourceValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, GetResourceValve.DEFAULT_SUBSTITUTION_NAME, "name");
        }
    }
}

