/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.ConfigurationPoints;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class SchemaUtil {
    private static final String SPRINGEXT_BASE_URI = "http://www.alibaba.com/schema/springext/base";
    private static final String SPRINGEXT_BASE_XSD = "http://www.alibaba.com/schema/springext/springext-base.xsd";
    private static final Namespace XSD = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final QName XSD_ANY = DocumentHelper.createQName((String)"any", (Namespace)XSD);
    private static final QName XSD_IMPORT = DocumentHelper.createQName((String)"import", (Namespace)XSD);
    private static final QName XSD_CHOICE = DocumentHelper.createQName((String)"choice", (Namespace)XSD);
    private static final QName XSD_ELEMENT = DocumentHelper.createQName((String)"element", (Namespace)XSD);
    private static final QName XSD_INCLUDE = DocumentHelper.createQName((String)"include", (Namespace)XSD);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocument(InputStream istream, String systemId, boolean close) throws DocumentException {
        SAXReader reader = new SAXReader(false);
        Document doc = null;
        try {
            doc = reader.read(istream, systemId);
        }
        finally {
            if (close && istream != null) {
                try {
                    istream.close();
                }
                catch (Exception e) {}
            }
        }
        return doc;
    }

    public static String getDocumentText(Document doc, String charset) throws IOException {
        StringWriter writer = new StringWriter();
        SchemaUtil.writeDocument(doc, writer, charset);
        return writer.toString();
    }

    public static byte[] getDocumentContent(Document doc, String charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SchemaUtil.writeDocument(doc, baos, null);
        return baos.toByteArray();
    }

    public static void writeDocument(Document doc, OutputStream stream, String charset) throws IOException {
        charset = StringUtil.defaultIfEmpty(StringUtil.trimToNull(charset), "UTF-8");
        SchemaUtil.writeDocument(doc, new OutputStreamWriter(stream, charset), charset);
    }

    public static void writeDocument(Document doc, Writer writer, String charset) throws IOException {
        charset = StringUtil.defaultIfEmpty(StringUtil.trimToNull(charset), "UTF-8");
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(charset);
        format.setIndent(true);
        format.setIndentSize(4);
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        xmlWriter.write(doc);
        xmlWriter.flush();
    }

    public static byte[] getConfigurationPointSchemaContent(ConfigurationPoint configurationPoint, String version) {
        try {
            return SchemaUtil.getDocumentContent(SchemaUtil.createConfigurationPointSchema(configurationPoint, version), null);
        }
        catch (Exception e) {
            throw new ConfigurationPointException("Could not generate XML Schema for configuration point " + configurationPoint.getName(), e);
        }
    }

    private static Document createConfigurationPointSchema(ConfigurationPoint configurationPoint, String version) {
        Document doc = DocumentHelper.createDocument();
        Element schemaRoot = doc.addElement("xsd:schema");
        schemaRoot.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        schemaRoot.addNamespace("beans", "http://www.springframework.org/schema/beans");
        schemaRoot.addNamespace("springext", SPRINGEXT_BASE_URI);
        schemaRoot.addNamespace("", configurationPoint.getNamespaceUri());
        schemaRoot.addAttribute("targetNamespace", configurationPoint.getNamespaceUri());
        schemaRoot.addAttribute("elementFormDefault", "qualified");
        TreeSet<String> includings = CollectionUtil.createTreeSet();
        for (Contribution contrib : configurationPoint.getContributions()) {
            Schema contribSchema = contrib.getSchemas().getVersionedSchema(version);
            if (contribSchema == null) {
                contribSchema = contrib.getSchemas().getMainSchema();
            }
            if (contribSchema == null) continue;
            includings.add(contribSchema.getName());
        }
        for (String including : includings) {
            Element includeElement = schemaRoot.addElement("xsd:include");
            includeElement.addAttribute("schemaLocation", including);
        }
        if (configurationPoint.getDefaultElementName() != null) {
            Element importBeans = schemaRoot.addElement("xsd:import");
            importBeans.addAttribute("namespace", "http://www.springframework.org/schema/beans");
            importBeans.addAttribute("schemaLocation", "http://www.springframework.org/schema/beans/spring-beans.xsd");
            Element importSpringextBase = schemaRoot.addElement("xsd:import");
            importSpringextBase.addAttribute("namespace", SPRINGEXT_BASE_URI);
            importSpringextBase.addAttribute("schemaLocation", SPRINGEXT_BASE_XSD);
            Element element = schemaRoot.addElement("xsd:element");
            element.addAttribute("name", configurationPoint.getDefaultElementName());
            element.addAttribute("type", "springext:referenceableBeanType");
        }
        return doc;
    }

    public static byte[] getContributionSchemaContent(InputStream istream, String systemId, boolean close, ConfigurationPoints cps, ConfigurationPoint thisCp) throws DocumentException, IOException {
        Document doc = SchemaUtil.readDocument(istream, systemId, close);
        new ContributionSchemaTransformer(doc, cps, thisCp).transform();
        return SchemaUtil.getDocumentContent(doc, null);
    }

    public static byte[] getSchemaContentWithoutIncludes(Schema schema) throws IOException {
        Document doc = schema.getDocument();
        Element root = doc.getRootElement();
        if ("http://www.w3.org/2001/XMLSchema".equals(root.getNamespaceURI()) && "schema".equals(root.getName())) {
            Iterator i = root.elementIterator(XSD_INCLUDE);
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }
        return SchemaUtil.getDocumentContent(doc, null);
    }

    public static byte[] getSchemaContentWithIndirectIncludes(Schema schema, Map<String, Schema> includes) throws IOException {
        Document doc = schema.getDocument();
        Element root = doc.getRootElement();
        root.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        if ("http://www.w3.org/2001/XMLSchema".equals(root.getNamespaceURI()) && "schema".equals(root.getName())) {
            Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
            QName includeName = DocumentHelper.createQName((String)"include", (Namespace)xsd);
            Iterator i = root.elementIterator(includeName);
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            List nodes = root.elements();
            int i2 = 0;
            for (Schema includedSchema : includes.values()) {
                Element includeElement = DocumentHelper.createElement((String)"xsd:include");
                nodes.add(i2++, includeElement);
                includeElement.addAttribute("schemaLocation", includedSchema.getName());
            }
        }
        return SchemaUtil.getDocumentContent(doc, null);
    }

    public static String getNamespacePrefix(String preferredNsPrefix, String targetNamespace) {
        if (preferredNsPrefix != null) {
            return preferredNsPrefix;
        }
        String ns = targetNamespace;
        if (ns != null) {
            return ns.substring(ns.lastIndexOf("/") + 1);
        }
        return null;
    }

    private static class ContributionSchemaTransformer {
        private final Document doc;
        private final ConfigurationPoints cps;
        private final ConfigurationPoint thisCp;
        private Element root;
        private Map<String, ConfigurationPoint> importings = CollectionUtil.createHashMap();

        public ContributionSchemaTransformer(Document doc, ConfigurationPoints cps, ConfigurationPoint thisCp) {
            this.doc = doc;
            this.cps = cps;
            this.thisCp = thisCp;
        }

        public void transform() {
            this.root = this.doc.getRootElement();
            if (!"http://www.w3.org/2001/XMLSchema".equals(this.root.getNamespaceURI()) || !"schema".equals(this.root.getName())) {
                return;
            }
            this.visitElement(this.root);
            List importElements = this.root.elements(XSD_IMPORT);
            for (Element importElement : importElements) {
                if (importElement.attribute("namespace") == null) continue;
                this.importings.remove(importElement.attribute("namespace").getValue());
            }
            List rootElements = this.root.elements();
            int importIndex = 0;
            for (ConfigurationPoint cp : this.importings.values()) {
                if (this.thisCp == cp) continue;
                Element importElement = DocumentHelper.createElement((QName)XSD_IMPORT);
                importElement.addAttribute("namespace", cp.getNamespaceUri());
                importElement.addAttribute("schemaLocation", cp.getSchemas().getMainSchema().getName());
                rootElements.add(importIndex++, importElement);
            }
        }

        private void visitElement(Element element) {
            List elements = element.elements();
            this.visitElements(elements);
        }

        private void visitElements(List<Element> elements) {
            LinkedList<Integer> indexes = CollectionUtil.createLinkedList();
            int index = 0;
            for (Element subElement : elements) {
                if (subElement.getQName().equals((Object)XSD_ANY) && subElement.attribute("namespace") != null) {
                    String ns = subElement.attribute("namespace").getValue();
                    ConfigurationPoint cp = this.cps.getConfigurationPointByNamespaceUri(ns);
                    if (cp != null) {
                        indexes.add(index);
                        this.importings.put(ns, cp);
                    }
                } else {
                    this.visitElement(subElement);
                }
                ++index;
            }
            for (Integer i : indexes) {
                this.visitAnyElement(elements, i);
            }
        }

        private void visitAnyElement(List<Element> elements, int index) {
            Element anyElement = elements.get(index);
            String ns = anyElement.attribute("namespace").getValue();
            ConfigurationPoint cp = this.cps.getConfigurationPointByNamespaceUri(ns);
            if (cp != null) {
                Element choiceElement = DocumentHelper.createElement((QName)XSD_CHOICE);
                String nsPrefix = SchemaUtil.getNamespacePrefix(cp.getPreferredNsPrefix(), ns);
                this.root.addNamespace(nsPrefix, ns);
                if (anyElement.attribute("minOccurs") != null) {
                    choiceElement.addAttribute("minOccurs", anyElement.attribute("minOccurs").getValue());
                }
                if (anyElement.attribute("maxOccurs") != null) {
                    choiceElement.addAttribute("maxOccurs", anyElement.attribute("maxOccurs").getValue());
                }
                for (Contribution contrib : cp.getContributions()) {
                    Element elementElement = DocumentHelper.createElement((QName)XSD_ELEMENT);
                    elementElement.addAttribute("ref", nsPrefix + ":" + contrib.getName());
                    choiceElement.add(elementElement);
                }
                if (cp.getDefaultElementName() != null) {
                    Element elementElement = DocumentHelper.createElement((QName)XSD_ELEMENT);
                    elementElement.addAttribute("ref", nsPrefix + ":" + cp.getDefaultElementName());
                    choiceElement.add(elementElement);
                }
                elements.set(index, choiceElement);
            }
        }
    }
}

