/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.export;

import com.alibaba.citrus.springext.DocumentFilter;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.impl.ConfigurationPointsImpl;
import com.alibaba.citrus.springext.support.SchemaSet;
import com.alibaba.citrus.springext.support.resolver.SpringPluggableSchemas;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;

public class SchemaExporter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Entries entries = new Entries();
    private final SchemaSet schemas;
    private final Map<String, Set<Schema>> nsToSchemas;

    public SchemaExporter() {
        this((ResourceLoader)null);
    }

    public SchemaExporter(ResourceLoader resourceLoader) {
        this(new ConfigurationPointsImpl(resourceLoader == null ? null : resourceLoader.getClassLoader()), new SpringPluggableSchemas(resourceLoader));
    }

    public SchemaExporter(Schemas ... schemasList) {
        this.schemas = new SchemaSet(schemasList);
        this.nsToSchemas = CollectionUtil.createHashMap();
        for (Schema schema : this.schemas.getNamedMappings().values()) {
            this.entries.put(schema.getName(), new Entry(schema.getName(), schema));
            String namespace = schema.getTargetNamespace();
            if (namespace == null) continue;
            Set<Schema> nsSchemas = this.nsToSchemas.get(namespace);
            if (nsSchemas == null) {
                nsSchemas = CollectionUtil.createTreeSet(new Comparator<Schema>(){

                    @Override
                    public int compare(Schema o1, Schema o2) {
                        return o2.getName().compareTo(o1.getName());
                    }
                });
                this.nsToSchemas.put(namespace, nsSchemas);
            }
            nsSchemas.add(schema);
        }
    }

    private Entries getEntries() {
        return this.entries;
    }

    public Entry getRootEntry() {
        return this.getEntries().getRoot();
    }

    public Entry getEntry(String path) {
        return (Entry)this.getEntries().get(path);
    }

    public void writeTo(Writer out, Entry entry, String charset) throws IOException {
        this.writeTo(out, entry, charset, (String)null);
    }

    public void writeTo(Writer out, Entry entry, String charset, String uriPrefix) throws IOException {
        this.writeTo(out, entry, charset, uriPrefix == null ? null : new AddPrefixFilter(uriPrefix));
    }

    private void writeTo(Writer out, Entry entry, String charset, DocumentFilter filter) throws IOException {
        StreamUtil.writeText(entry.getSchema().getText(charset, filter), out, true);
    }

    private class AddPrefixFilter
    implements DocumentFilter {
        private final String prefix;

        public AddPrefixFilter(String prefix) {
            if (prefix != null && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            this.prefix = prefix;
        }

        @Override
        public Document filter(Document doc, String systemId) {
            Element root;
            if (this.prefix != null && "http://www.w3.org/2001/XMLSchema".equals((root = doc.getRootElement()).getNamespaceURI()) && "schema".equals(root.getName())) {
                String schemaLocation;
                Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
                QName includeName = DocumentHelper.createQName((String)"include", (Namespace)xsd);
                QName importName = DocumentHelper.createQName((String)"import", (Namespace)xsd);
                Iterator i = root.elementIterator(includeName);
                while (i.hasNext()) {
                    Element includeElement = (Element)i.next();
                    schemaLocation = StringUtil.trimToNull(includeElement.attributeValue("schemaLocation"));
                    if (schemaLocation == null || (schemaLocation = this.getNewSchemaLocation(schemaLocation, null, systemId)) == null) continue;
                    includeElement.addAttribute("schemaLocation", schemaLocation);
                }
                i = root.elementIterator(importName);
                while (i.hasNext()) {
                    Element importElement = (Element)i.next();
                    schemaLocation = importElement.attributeValue("schemaLocation");
                    String namespace = StringUtil.trimToNull(importElement.attributeValue("namespace"));
                    if (schemaLocation == null && namespace == null || (schemaLocation = this.getNewSchemaLocation(schemaLocation, namespace, systemId)) == null) continue;
                    importElement.addAttribute("schemaLocation", schemaLocation);
                }
            }
            return doc;
        }

        private String getNewSchemaLocation(String schemaLocation, String namespace, String systemId) {
            Set nsSchemas;
            if (schemaLocation != null) {
                Schema schema = SchemaExporter.this.schemas.findSchema(schemaLocation);
                if (schema != null) {
                    return this.prefix + schema.getName();
                }
                return schemaLocation;
            }
            if (namespace != null && (nsSchemas = (Set)SchemaExporter.this.nsToSchemas.get(namespace)) != null && !nsSchemas.isEmpty()) {
                String versionedExtension = this.getVersionedExtension(systemId);
                if (versionedExtension != null) {
                    for (Schema schema : nsSchemas) {
                        if (!schema.getName().endsWith(versionedExtension)) continue;
                        return this.prefix + schema.getName();
                    }
                }
                return this.prefix + ((Schema)nsSchemas.iterator().next()).getName();
            }
            return null;
        }

        private String getVersionedExtension(String systemId) {
            int slashIndex;
            int dashIndex;
            if (systemId != null && (dashIndex = systemId.lastIndexOf("-")) > (slashIndex = systemId.lastIndexOf("/"))) {
                return systemId.substring(dashIndex);
            }
            return null;
        }
    }

    private final class Entries
    extends HashMap<String, Entry> {
        private static final long serialVersionUID = -4000525580274040823L;

        public Entries() {
            super.put("", new Entry());
        }

        public Entry getRoot() {
            return (Entry)this.get("");
        }

        @Override
        public Entry put(String path, Entry entry) {
            String parentPath;
            Entry parentEntry;
            Assert.assertTrue(path.equals(entry.getPath()));
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((parentEntry = (Entry)this.get(parentPath = path.substring(0, path.lastIndexOf("/") + 1))) == null) {
                parentEntry = new Entry(parentPath);
                this.put(parentPath, parentEntry);
            }
            parentEntry.subEntries.put(entry.getSortKey(), entry);
            Entry old = super.put(entry.getPath(), entry);
            SchemaExporter.this.log.trace("Added entry: {}", (Object)entry.getPath());
            return old;
        }
    }

    public static final class Entry {
        private final String path;
        private final String name;
        private final boolean directory;
        private final boolean root;
        private final Schema schema;
        private final Map<String, Entry> subEntries;
        private static final String PREFIX_ITEM = "+---";
        private static final String PREFIX_LAST_ITEM = "\\---";
        private static final String INDENT_BEFORE_LAST_ITEM = "|   ";
        private static final String INDENT_AFTER_LAST_ITEM = "    ";

        private Entry() {
            this.path = "";
            this.name = "";
            this.directory = true;
            this.root = true;
            this.schema = null;
            this.subEntries = CollectionUtil.createTreeMap();
        }

        public Entry(String path) {
            this(path, null);
        }

        public Entry(String path, Schema schema) {
            this.path = Assert.assertNotNull(StringUtil.trimToNull(path), "path", new Object[0]);
            this.directory = path.endsWith("/");
            int fromIndex = this.directory ? path.length() - 2 : path.length();
            this.name = path.substring(path.lastIndexOf("/", fromIndex) + 1);
            this.root = false;
            this.schema = schema;
            this.subEntries = CollectionUtil.createTreeMap();
            if (this.directory) {
                Assert.assertNull(schema, "schema", new Object[0]);
            } else {
                Assert.assertNotNull(schema, "schema", new Object[0]);
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getId() {
            if (this.isRoot()) {
                return "ROOT";
            }
            return this.path.replaceFirst("\\.[^-\\./]*$|/+$", "").replace('/', '-').replace('.', '-');
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public boolean isRoot() {
            return this.root;
        }

        public Collection<Entry> getSubEntries() {
            return this.subEntries.values();
        }

        public Schema getSchema() {
            return this.schema;
        }

        public boolean containsSchemaWithTargetNamespace() {
            boolean hasNs = false;
            if (this.isDirectory()) {
                for (Entry subEntry : this.getSubEntries()) {
                    if (!subEntry.containsSchemaWithTargetNamespace()) continue;
                    hasNs = true;
                    break;
                }
            } else if (this.getSchema() != null) {
                hasNs = this.getSchema().getTargetNamespace() != null;
            }
            return hasNs;
        }

        public String tree() {
            StringWriter sw = new StringWriter();
            try {
                this.tree(sw);
            }
            catch (IOException e) {
                Assert.unexpectedException(e);
            }
            return sw.toString();
        }

        public void tree(Appendable buf) throws IOException {
            this.tree(buf, "");
        }

        public void tree(Appendable buf, String prefix) throws IOException {
            this.tree(buf, prefix, prefix);
        }

        private void tree(Appendable buf, String prefix, String indent) throws IOException {
            buf.append(prefix).append(this.getName()).append("\n");
            Iterator<Entry> i = this.subEntries.values().iterator();
            while (i.hasNext()) {
                String subIndent;
                String subPrefix;
                Entry subEntry = i.next();
                if (i.hasNext()) {
                    subPrefix = indent + PREFIX_ITEM;
                    subIndent = indent + INDENT_BEFORE_LAST_ITEM;
                } else {
                    subPrefix = indent + PREFIX_LAST_ITEM;
                    subIndent = indent + INDENT_AFTER_LAST_ITEM;
                }
                subEntry.tree(buf, subPrefix, subIndent);
            }
        }

        private String getSortKey() {
            String name = this.getName();
            if (!this.isDirectory()) {
                int dotIndex;
                int slashIndex = name.lastIndexOf("/");
                if (slashIndex < (dotIndex = name.lastIndexOf(".")) && dotIndex >= 0) {
                    return "0-" + name.substring(0, dotIndex);
                }
                return "0-" + name;
            }
            return "1-" + name;
        }

        public String toString() {
            return this.root ? "/" : this.path;
        }
    }
}

