/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.support;

import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.velocity.FastCloneable;
import com.alibaba.citrus.service.velocity.VelocityConfiguration;
import com.alibaba.citrus.service.velocity.VelocityPlugin;
import com.alibaba.citrus.service.velocity.support.InterpolationUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.ContextAware;
import org.apache.velocity.util.introspection.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class EscapeSupport
implements VelocityPlugin,
ReferenceInsertionEventHandler,
ContextAware,
FastCloneable,
ProductionModeAware {
    private static final Logger log = LoggerFactory.getLogger(EscapeSupport.class);
    private static final String ESCAPE_TYPE_KEY = "_ESCAPE_SUPPORT_TYPE_";
    private ResourceLoader loader;
    private EscapeType defaultEscape;
    private EscapeRule[] escapeRules;
    private boolean cacheReferences;
    private Map<String, EscapeType> referenceCache = CollectionUtil.createConcurrentHashMap();
    private transient Context context;
    private static final Pattern referencePattern = Pattern.compile("\\s*\\$\\s*\\!?\\s*(\\{\\s*(.*?)\\s*\\}|(.*?))\\s*");

    @Override
    public Object createCopy() {
        EscapeSupport copy = new EscapeSupport();
        copy.loader = this.loader;
        copy.defaultEscape = this.defaultEscape;
        copy.escapeRules = this.escapeRules;
        copy.cacheReferences = this.cacheReferences;
        copy.referenceCache = this.referenceCache;
        return copy;
    }

    @Override
    public void setProductionMode(boolean productionMode) {
        this.cacheReferences = productionMode;
    }

    public void setDefaultEscape(String defaultEscapeType) {
        this.defaultEscape = EscapeType.getEscapeType(defaultEscapeType);
    }

    public void setEscapeRules(EscapeRule[] escapeRules) {
        this.escapeRules = escapeRules;
    }

    @Override
    public void init(VelocityConfiguration configuration) throws Exception {
        this.loader = configuration.getResourceLoader();
        configuration.getProperties().addProperty("userdirective", (Object)Escape.class.getName());
        configuration.getProperties().addProperty("userdirective", (Object)Noescape.class.getName());
    }

    @Override
    public Resource[] getMacros() throws IOException {
        String resourceName = "classpath:" + this.getClass().getPackage().getName().replace('.', '/') + "/escape_macros.vm";
        Resource resource = Assert.assertNotNull(this.loader, "loader", new Object[0]).getResource(resourceName);
        return new Resource[]{resource};
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Object referenceInsert(String reference, Object value) {
        Assert.assertNotNull(this.context, "context", new Object[0]);
        if (value == null) {
            return null;
        }
        if (InterpolationUtil.isInInterpolation(this.context) || value instanceof Renderable) {
            return value;
        }
        EscapeType escapeType = this.getEscapeType(reference);
        if (escapeType == null) {
            return value;
        }
        return escapeType.escape(value);
    }

    private EscapeType getEscapeType(String reference) {
        EscapeType escapeType = (EscapeType)((Object)this.context.get(ESCAPE_TYPE_KEY));
        if (escapeType != null) {
            log.debug("{} specified for reference {}", (Object)escapeType, (Object)reference);
            return escapeType;
        }
        if (this.cacheReferences) {
            escapeType = this.referenceCache.get(reference);
        }
        if (escapeType == null) {
            escapeType = this.findEscapeType(reference);
            if (this.cacheReferences) {
                this.referenceCache.put(reference, escapeType);
            }
        }
        return escapeType;
    }

    private EscapeType findEscapeType(String reference) {
        EscapeType escapeType = null;
        String normalizedRef = EscapeSupport.normalizeReference(reference);
        if (!ArrayUtil.isEmptyArray(this.escapeRules)) {
            for (EscapeRule rule : this.escapeRules) {
                Pattern matchedPattern = rule.matches(normalizedRef);
                if (matchedPattern == null) continue;
                escapeType = rule.getEscapeType();
                if (!log.isDebugEnabled()) break;
                log.debug("{} matched {} for reference {}", new Object[]{escapeType, matchedPattern, reference});
                break;
            }
        }
        if (escapeType == null) {
            escapeType = this.defaultEscape;
            log.debug("{} used by default for reference {}", (Object)escapeType, (Object)reference);
        }
        return escapeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean renderWithEscape(EscapeType escapeType, InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        EscapeType savedEscapeType = EscapeSupport.setEscapeType(escapeType, context);
        try {
            boolean bl = node.render(context, writer);
            return bl;
        }
        finally {
            EscapeSupport.setEscapeType(savedEscapeType, context);
        }
    }

    public static EscapeType setEscapeType(EscapeType escapeType, InternalContextAdapter context) {
        if (escapeType == null) {
            return (EscapeType)((Object)context.remove((Object)ESCAPE_TYPE_KEY));
        }
        return (EscapeType)((Object)context.localPut(ESCAPE_TYPE_KEY, (Object)escapeType));
    }

    private static String normalizeReference(String reference) {
        if (reference == null) {
            return "";
        }
        Matcher matcher = referencePattern.matcher(reference);
        if (matcher.matches()) {
            String form1 = matcher.group(2);
            String form2 = matcher.group(3);
            if (form1 == null) {
                return form2;
            }
            return form1;
        }
        return reference;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class EscapeRule {
        private final Pattern pattern;
        private final EscapeType escape;

        public EscapeRule(String escapeType, String[] patterns) {
            this.escape = Assert.assertNotNull(EscapeType.getEscapeType(escapeType), "no escapeType specified", new Object[0]);
            Assert.assertTrue(!ArrayUtil.isEmptyArray(patterns), "no pattern specified", new Object[0]);
            StringBuilder buf = new StringBuilder();
            for (String pattern : patterns) {
                pattern = Assert.assertNotNull(StringUtil.trimToNull(pattern), "no pattern", new Object[0]);
                if (buf.length() > 0) {
                    buf.append("|");
                }
                buf.append("(").append(pattern).append(")");
            }
            this.pattern = Pattern.compile(buf.toString(), 2);
        }

        public Pattern matches(String reference) {
            if (this.pattern.matcher(reference).find()) {
                return this.pattern;
            }
            return null;
        }

        public EscapeType getEscapeType() {
            return this.escape;
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("escape", (Object)this.escape);
            mb.append("pattern", this.pattern);
            return new ToStringBuilder().append("EscapeRule").append(mb).toString();
        }
    }

    public static class Noescape
    extends Directive {
        public String getName() {
            return "noescape";
        }

        public int getType() {
            return 1;
        }

        public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
            super.init(rs, context, node);
            if (node.jjtGetNumChildren() != 1) {
                throw new TemplateInitException("Invalid args for #" + this.getName() + ".  Expected 0 args.", context.getCurrentTemplateName(), node.getColumn(), node.getLine());
            }
        }

        public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
            return EscapeSupport.renderWithEscape(EscapeType.NO_ESCAPE, context, writer, node.jjtGetChild(0));
        }
    }

    public static class Escape
    extends Directive {
        public String getName() {
            return "escape";
        }

        public int getType() {
            return 1;
        }

        public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
            super.init(rs, context, node);
            if (node.jjtGetNumChildren() != 2) {
                throw new TemplateInitException("Invalid args for #" + this.getName() + ".  Expected 1 and only 1 string arg.", context.getCurrentTemplateName(), node.getColumn(), node.getLine());
            }
        }

        public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
            Node escapeTypeNode = node.jjtGetChild(0);
            Object escapeTypeObject = escapeTypeNode.value(context);
            String escapeTypeString = escapeTypeObject == null ? null : escapeTypeObject.toString();
            EscapeType escapeType = EscapeType.getEscapeType(escapeTypeString);
            if (escapeType == null) {
                throw new ParseErrorException("Invalid escape type: " + escapeTypeObject + " at " + new Info(escapeTypeNode.getTemplateName(), escapeTypeNode.getColumn(), escapeTypeNode.getLine()) + ".  Available escape types: " + EscapeType.getNames());
            }
            return EscapeSupport.renderWithEscape(escapeType, context, writer, node.jjtGetChild(1));
        }
    }

    public static enum EscapeType {
        NO_ESCAPE("noescape"){

            @Override
            public Object escape(Object value) {
                return value;
            }

            @Override
            protected String escape(String strValue) {
                Assert.unreachableCode();
                return strValue;
            }

            @Override
            public String toString() {
                return "#noescape()";
            }
        }
        ,
        JAVA("java"){

            @Override
            protected String escape(String strValue) {
                return StringEscapeUtil.escapeJava(strValue);
            }
        }
        ,
        JAVA_SCRIPT("javascript"){

            @Override
            protected String escape(String strValue) {
                return StringEscapeUtil.escapeJavaScript(strValue);
            }
        }
        ,
        HTML("html"){

            @Override
            protected String escape(String strValue) {
                return StringEscapeUtil.escapeHtml(strValue);
            }
        }
        ,
        XML("xml"){

            @Override
            protected String escape(String strValue) {
                return StringEscapeUtil.escapeXml(strValue);
            }
        }
        ,
        URL("url"){

            @Override
            protected String escape(String strValue) {
                return StringEscapeUtil.escapeURL(strValue);
            }
        }
        ,
        SQL("sql"){

            @Override
            protected String escape(String strValue) {
                return StringEscapeUtil.escapeSql(strValue);
            }
        };

        private static final Map<String, EscapeType> namedTypes;
        private static final ArrayList<String> names;
        private final String name;

        private EscapeType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object escape(Object value) {
            return this.escape(value.toString());
        }

        protected abstract String escape(String var1);

        public static EscapeType getEscapeType(String name) {
            if ((name = StringUtil.trimToNull(name)) != null) {
                return namedTypes.get(name.toLowerCase());
            }
            return null;
        }

        public static List<String> getNames() {
            return names;
        }

        public String toString() {
            return "#escape(\"" + this.getName() + "\")";
        }

        static {
            namedTypes = CollectionUtil.createHashMap();
            names = CollectionUtil.createArrayList();
            for (EscapeType escapeType : EscapeType.values()) {
                namedTypes.put(escapeType.getName(), escapeType);
                names.add(escapeType.getName());
            }
            names.trimToSize();
        }
    }
}

