/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.service.template.TemplateContext;
import com.alibaba.citrus.service.template.TemplateException;
import com.alibaba.citrus.service.template.TemplateNotFoundException;
import com.alibaba.citrus.service.velocity.VelocityEngine;
import com.alibaba.citrus.service.velocity.impl.CloneableEventCartridge;
import com.alibaba.citrus.service.velocity.impl.TemplateContextAdapter;
import com.alibaba.citrus.service.velocity.impl.VelocityConfigurationImpl;
import com.alibaba.citrus.service.velocity.impl.VelocityRuntimeInstance;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.AbstractContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalEventContext;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class VelocityEngineImpl
extends AbstractService<VelocityEngine>
implements VelocityEngine,
ResourceLoaderAware,
ProductionModeAware {
    private static final String RUNTIME_SERVICES_KEY = "_runtime_services";
    private final VelocityRuntimeInstance ri = new VelocityRuntimeInstance();
    private final VelocityConfigurationImpl configuration = new VelocityConfigurationImpl(this.getLogger());
    private String defaultInputEncoding;
    private String defaultOutpuEncoding;

    public RuntimeServices getRuntimeServices() {
        return this.ri;
    }

    public VelocityConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.configuration.setResourceLoader(loader);
    }

    @Override
    public void setProductionMode(boolean productionMode) {
        this.configuration.setProductionMode(productionMode);
    }

    @Override
    protected void init() throws Exception {
        this.configuration.init();
        this.getLogger().debug("Velocity Engine Configurations: {}", (Object)this.configuration);
        this.ri.setConfiguration(this.configuration.getProperties());
        this.ri.setApplicationAttribute("_spring_resource_loader", this.configuration.getResourceLoader());
        this.ri.setProperty("eventhandler.referenceinsertion.class", RuntimeServicesExposer.class.getName());
        this.ri.init();
        CloneableEventCartridge eventCartridge = this.configuration.getEventCartridge();
        RuntimeServices rs = Assert.assertNotNull((RuntimeServices)this.ri.getProperty(RUNTIME_SERVICES_KEY), "RuntimeServices", new Object[0]);
        eventCartridge.initOnce(rs);
    }

    @Override
    public String[] getDefaultExtensions() {
        return new String[]{"vm"};
    }

    @Override
    public boolean exists(String templateName) {
        return this.ri.getLoaderNameForResource(templateName) != null;
    }

    @Override
    public String getText(String templateName, TemplateContext context) throws TemplateException, IOException {
        return this.mergeTemplate(templateName, (Context)new TemplateContextAdapter(context), null);
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, OutputStream ostream) throws TemplateException, IOException {
        this.mergeTemplate(templateName, (Context)new TemplateContextAdapter(context), ostream, null, null);
    }

    @Override
    public void writeTo(String templateName, TemplateContext context, Writer writer) throws TemplateException, IOException {
        this.mergeTemplate(templateName, (Context)new TemplateContextAdapter(context), writer, null);
    }

    @Override
    public String mergeTemplate(String templateName, Context context, String inputEncoding) throws TemplateException, IOException {
        StringWriter writer = new StringWriter();
        this.mergeTemplate(templateName, context, writer, inputEncoding);
        return writer.toString();
    }

    @Override
    public void mergeTemplate(String templateName, Context context, OutputStream ostream, String inputEncoding, String outputEncoding) throws TemplateException, IOException {
        if (StringUtil.isEmpty(outputEncoding)) {
            outputEncoding = this.getDefaultOutputEncoding();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(ostream, outputEncoding);
        }
        catch (UnsupportedEncodingException e) {
            this.error(templateName, e);
        }
        this.mergeTemplate(templateName, context, writer, inputEncoding);
        writer.flush();
    }

    @Override
    public void mergeTemplate(String templateName, Context context, Writer writer, String inputEncoding) throws TemplateException, IOException {
        if (StringUtil.isEmpty(inputEncoding)) {
            inputEncoding = this.getDefaultInputEncoding();
        }
        try {
            Context eventContext = this.attachEventCartridge(context);
            this.mergeTemplate(templateName, inputEncoding, eventContext, writer);
        }
        catch (Exception e) {
            this.error(templateName, e);
        }
    }

    private boolean mergeTemplate(String templateName, String encoding, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        Template template = this.ri.getTemplate(templateName, encoding);
        if (template == null) {
            String msg = "VelocityEngine.mergeTemplate() was unable to load template '" + templateName + "'";
            this.ri.getLog().error((Object)msg);
            throw new ResourceNotFoundException(msg);
        }
        template.merge(context, writer);
        return true;
    }

    private Context attachEventCartridge(Context context) {
        Object eventContext = context instanceof InternalEventContext ? context : new EventContext(context);
        EventCartridge ec = this.configuration.getEventCartridge().getRuntimeInstance();
        if (ec != null) {
            Assert.assertTrue(ec.attachToContext(eventContext), "Could not attach EventCartridge to velocity context", new Object[0]);
        }
        return eventContext;
    }

    protected String getDefaultInputEncoding() {
        if (this.defaultInputEncoding == null) {
            this.defaultInputEncoding = ObjectUtil.defaultIfNull(StringUtil.trimToNull((String)this.ri.getProperty("input.encoding")), "UTF-8");
        }
        return this.defaultInputEncoding;
    }

    protected String getDefaultOutputEncoding() {
        if (this.defaultOutpuEncoding == null) {
            this.defaultOutpuEncoding = ObjectUtil.defaultIfNull(StringUtil.trimToNull((String)this.ri.getProperty("output.encoding")), "UTF-8");
        }
        return this.defaultOutpuEncoding;
    }

    private final void error(String templateName, Throwable e) throws TemplateException {
        String err = "Error rendering Velocity template: " + templateName;
        this.getLogger().error(err + ": " + e.getMessage());
        if (e instanceof ResourceNotFoundException) {
            throw new TemplateNotFoundException(err, e);
        }
        if (e instanceof TemplateException) {
            throw (TemplateException)e;
        }
        throw new TemplateException(err, e);
    }

    private static class EventContext
    extends AbstractContext {
        private final Context context;

        public EventContext(Context context) {
            this.context = Assert.assertNotNull(context, "no context", new Object[0]);
        }

        public Object internalGet(String key) {
            return this.context.get(key);
        }

        public Object internalPut(String key, Object value) {
            return this.context.put(key, value);
        }

        public boolean internalContainsKey(Object key) {
            return this.context.containsKey(key);
        }

        public Object[] internalGetKeys() {
            return this.context.getKeys();
        }

        public Object internalRemove(Object key) {
            return this.context.remove(key);
        }

        public String toString() {
            return this.context.toString();
        }
    }

    public static class RuntimeServicesExposer
    implements ReferenceInsertionEventHandler,
    RuntimeServicesAware {
        public Object referenceInsert(String reference, Object value) {
            return value;
        }

        public void setRuntimeServices(RuntimeServices rs) {
            rs.getConfiguration().setProperty(VelocityEngineImpl.RUNTIME_SERVICES_KEY, (Object)rs);
        }
    }
}

