/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.store.cookie.impl;

import com.alibaba.citrus.service.requestcontext.session.ExactMatchesOnlySessionStore;
import com.alibaba.citrus.service.requestcontext.session.SessionStore;
import com.alibaba.citrus.service.requestcontext.session.store.cookie.AbstractCookieStore;
import com.alibaba.citrus.service.requestcontext.session.valueencoder.SessionValueEncoder;
import com.alibaba.citrus.service.requestcontext.session.valueencoder.impl.SimpleValueEncoder;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class SingleValuedCookieStoreImpl
extends AbstractCookieStore
implements ExactMatchesOnlySessionStore {
    private String[] attrNames;
    private SessionValueEncoder[] encoders;

    @Override
    public void initAttributeNames(String[] attrNames) {
        this.attrNames = attrNames;
        Assert.assertTrue(attrNames.length <= 1, "Session store %s supports only 1 mapping to attribute name", this.getName());
    }

    public void setValueEncoders(SessionValueEncoder[] encoders) {
        this.encoders = encoders;
    }

    @Override
    protected void init() throws Exception {
        if (ArrayUtil.isEmptyArray(this.encoders)) {
            this.encoders = new SessionValueEncoder[]{this.createDefaultSessionValueEncoder()};
        }
    }

    protected SessionValueEncoder createDefaultSessionValueEncoder() throws Exception {
        SimpleValueEncoder simpleValueEncoder = new SimpleValueEncoder();
        simpleValueEncoder.afterPropertiesSet();
        return simpleValueEncoder;
    }

    @Override
    public Iterable<String> getAttributeNames(String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        return state.attributes.keySet();
    }

    @Override
    public Object loadAttribute(String attrName, String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        return state.attributes.get(attrName);
    }

    @Override
    public void invaldiate(String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        if (!this.isSurvivesInInvalidating()) {
            state.attributes.clear();
        }
    }

    @Override
    public void commit(Map<String, Object> modifiedAttrs, String sessionID, SessionStore.StoreContext storeContext) {
        State state = this.getState(storeContext);
        if (state.cookieCommitted) {
            return;
        }
        state.cookieCommitted = true;
        String attrName = this.attrNames[0];
        if (modifiedAttrs.containsKey(attrName)) {
            Object attrValue = modifiedAttrs.get(attrName);
            if (attrValue == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Remove from session: {}", (Object)attrName);
                }
                state.attributes.remove(attrName);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set to session: {} = {}", (Object)attrName, attrValue);
                }
                state.attributes.put(attrName, attrValue);
            }
        }
        String cookieState = null;
        if (!state.attributes.isEmpty()) {
            try {
                cookieState = this.encoders[0].encode(state.attributes.get(attrName), storeContext);
            }
            catch (Exception e) {
                this.log.warn("Failed to encode session state", (Throwable)e);
            }
        }
        cookieState = StringUtil.trimToEmpty(cookieState);
        this.writeCookie(storeContext.getSessionRequestContext().getResponse(), this.getName(), cookieState);
    }

    private State getState(SessionStore.StoreContext storeContext) {
        State state = (State)storeContext.getState();
        if (state == null) {
            state = new State();
            storeContext.setState(state);
        }
        this.ensureCookieLoading(state, storeContext.getSessionRequestContext().getRequest(), storeContext);
        return state;
    }

    private void ensureCookieLoading(State state, HttpServletRequest request, SessionStore.StoreContext storeContext) {
        if (state.cookieLoaded) {
            return;
        }
        state.cookieLoaded = true;
        state.requestCookieValue = this.readCookie(request);
        state.attributes = this.decodeCookieValue(state.requestCookieValue, storeContext);
    }

    private String readCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        String cookieValue = null;
        for (Cookie cookie : cookies) {
            String cookieName = cookie.getName();
            if (!this.getName().equals(cookieName)) continue;
            cookieValue = cookie.getValue();
            if (!this.log.isDebugEnabled()) break;
            this.log.debug("[{}] Loading cookie: {}[length={}]={}", new Object[]{this.getStoreName(), this.getName(), cookie.getValue().length(), cookie.getValue()});
            break;
        }
        return cookieValue;
    }

    private Map<String, Object> decodeCookieValue(String cookieValue, SessionStore.StoreContext storeContext) {
        HashMap<String, Object> attrs = CollectionUtil.createHashMap(4);
        if (cookieValue == null) {
            return attrs;
        }
        LinkedList<Exception> encoderExceptions = null;
        for (SessionValueEncoder encoder : this.encoders) {
            try {
                attrs.put(this.attrNames[0], encoder.decode(cookieValue, storeContext));
                this.log.debug("Succeeded decoding cookieValue using {}", (Object)encoder);
                break;
            }
            catch (Exception e) {
                if (encoderExceptions == null) {
                    encoderExceptions = CollectionUtil.createLinkedList();
                }
                encoderExceptions.add(e);
                this.log.trace("Failure decoding cookieValue using {}: {}", (Object)encoder, (Object)e.getMessage());
            }
        }
        if (attrs.isEmpty() && encoderExceptions != null) {
            if (this.log.isWarnEnabled()) {
                ToStringBuilder buf = new ToStringBuilder();
                buf.append("Failed to decode cookie value: ").append(cookieValue);
                int i = 0;
                for (Exception e : encoderExceptions) {
                    buf.format("\n  Encoder #%d - %s threw %s", i + 1, this.encoders[i].getClass().getSimpleName(), e);
                }
                this.log.warn(buf.toString());
            }
        } else if (this.log.isDebugEnabled()) {
            int attrCount = attrs.size();
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Found %d attributes:", attrCount);
            if (!attrs.isEmpty()) {
                buf.append(new ToStringBuilder.MapBuilder().setPrintCount(true).setSortKeys(true).appendAll(attrs));
            }
            this.log.debug(buf.toString());
        }
        return attrs;
    }

    @Override
    protected void toString(ToStringBuilder.MapBuilder mb) {
        super.toString(mb);
        mb.append("encoders", this.encoders);
    }

    private class State {
        private boolean cookieLoaded;
        private boolean cookieCommitted;
        private String requestCookieValue;
        private Map<String, Object> attributes;

        private State() {
        }
    }
}

