/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.parser.filter;

import com.alibaba.citrus.logconfig.support.SecurityLogger;
import com.alibaba.citrus.service.requestcontext.parser.UploadedFileFilter;
import com.alibaba.citrus.springext.support.BeanSupport;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class UploadedFileExtensionWhitelist
extends BeanSupport
implements UploadedFileFilter {
    private final SecurityLogger log = new SecurityLogger();
    private String[] extensions;

    public void setAllowedExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public void setLogName(String logName) {
        this.log.setLogName(logName);
    }

    @Override
    public boolean isFiltering(HttpServletRequest request) {
        return true;
    }

    @Override
    protected void init() throws Exception {
        if (this.extensions == null) {
            this.extensions = BasicConstant.EMPTY_STRING_ARRAY;
        }
        for (int i = 0; i < this.extensions.length; ++i) {
            this.extensions[i] = FileUtil.normalizeExtension(this.extensions[i]);
        }
    }

    @Override
    public FileItem filter(String key, FileItem file) {
        if (file == null) {
            return null;
        }
        boolean allowed = false;
        String ext = FileUtil.getExtension(file.getName(), "null", true);
        if (ext != null) {
            for (String allowedExtension : this.extensions) {
                if (!allowedExtension.equals(ext)) continue;
                allowed = true;
                break;
            }
        }
        if (!allowed) {
            this.log.getLogger().warn("Uploaded file type \"{}\" is denied: {}", (Object)ext, (Object)file.getName());
            return null;
        }
        return file;
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<UploadedFileExtensionWhitelist> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "logName");
            String extensions = StringUtil.trimToNull(element.getAttribute("extensions"));
            if (extensions != null) {
                builder.addPropertyValue("allowedExtensions", (Object)extensions);
            }
        }
    }
}

