/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.lazycommit.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.lazycommit.LazyCommitFailedException;
import com.alibaba.citrus.service.requestcontext.lazycommit.LazyCommitRequestContext;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextWrapper;
import com.alibaba.citrus.service.requestcontext.support.AbstractResponseWrapper;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyCommitRequestContextImpl
extends AbstractRequestContextWrapper
implements LazyCommitRequestContext {
    private static final Logger log = LoggerFactory.getLogger(LazyCommitRequestContext.class);
    private SendError sendError;
    private String sendRedirect;
    private boolean setLocation;
    private boolean bufferFlushed;
    private int status;

    public LazyCommitRequestContextImpl(RequestContext wrappedContext) {
        super(wrappedContext);
        this.setResponse((HttpServletResponse)new ResponseWrapper(wrappedContext.getResponse()));
    }

    @Override
    public boolean isError() {
        return this.sendError != null;
    }

    @Override
    public int getErrorStatus() {
        if (this.sendError != null) {
            return this.sendError.status;
        }
        return 0;
    }

    @Override
    public String getErrorMessage() {
        if (this.sendError != null) {
            return this.sendError.message;
        }
        return null;
    }

    @Override
    public boolean isRedirected() {
        return this.setLocation || !StringUtil.isEmpty(this.sendRedirect);
    }

    @Override
    public String getRedirectLocation() {
        return this.sendRedirect;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void commit() throws LazyCommitFailedException {
        try {
            ((ResponseWrapper)this.getResponse()).commit();
        }
        catch (IOException e) {
            throw new LazyCommitFailedException(e);
        }
    }

    private class SendError {
        public final int status;
        public final String message;

        public SendError(int status, String message) {
            this.status = status;
            this.message = message;
        }
    }

    private class ResponseWrapper
    extends AbstractResponseWrapper {
        public ResponseWrapper(HttpServletResponse response) {
            super(LazyCommitRequestContextImpl.this, response);
        }

        public void sendError(int status) throws IOException {
            this.sendError(status, null);
        }

        public void sendError(int status, String message) throws IOException {
            if (LazyCommitRequestContextImpl.this.sendError == null && LazyCommitRequestContextImpl.this.sendRedirect == null) {
                LazyCommitRequestContextImpl.this.sendError = new SendError(status, message);
            }
        }

        public void sendRedirect(String location) throws IOException {
            if (LazyCommitRequestContextImpl.this.sendError == null && LazyCommitRequestContextImpl.this.sendRedirect == null) {
                LazyCommitRequestContextImpl.this.sendRedirect = location;
            }
        }

        public void setHeader(String key, String value) {
            if ("location".equalsIgnoreCase(key)) {
                LazyCommitRequestContextImpl.this.setLocation = true;
            }
            super.setHeader(key, value);
        }

        public void flushBuffer() throws IOException {
            LazyCommitRequestContextImpl.this.bufferFlushed = true;
        }

        public void setStatus(int sc) {
            LazyCommitRequestContextImpl.this.status = sc;
        }

        private void commit() throws IOException {
            if (LazyCommitRequestContextImpl.this.status > 0) {
                log.debug("Set HTTP status to " + LazyCommitRequestContextImpl.this.status);
                super.setStatus(LazyCommitRequestContextImpl.this.status);
            }
            if (LazyCommitRequestContextImpl.this.sendError != null) {
                if (((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.message == null) {
                    log.debug("Set error page: " + ((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.status);
                    super.sendError(((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.status);
                } else {
                    log.debug("Set error page: " + ((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.status + " " + ((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.message);
                    super.sendError(((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.status, ((LazyCommitRequestContextImpl)LazyCommitRequestContextImpl.this).sendError.message);
                }
            } else if (LazyCommitRequestContextImpl.this.sendRedirect != null) {
                log.debug("Set redirect location to " + LazyCommitRequestContextImpl.this.sendRedirect);
                String charset = this.getCharacterEncoding();
                if (charset != null) {
                    LazyCommitRequestContextImpl.this.sendRedirect = new String(LazyCommitRequestContextImpl.this.sendRedirect.getBytes(charset), "8859_1");
                }
                super.sendRedirect(LazyCommitRequestContextImpl.this.sendRedirect);
            }
            if (LazyCommitRequestContextImpl.this.bufferFlushed) {
                super.flushBuffer();
            }
        }
    }
}

