/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextChainingService;
import com.alibaba.citrus.service.requestcontext.RequestContextInfo;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.springext.util.ProxyTargetFactory;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(RequestContextBeanFactoryPostProcessor.class);
    private final String requestContextsName;

    public RequestContextBeanFactoryPostProcessor(String requestContextsName) {
        this.requestContextsName = requestContextsName;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.register(beanFactory, ServletRequest.class, SpringExtUtil.createProxy(HttpServletRequest.class, beanFactory.getBeanClassLoader(), new RequestProxyTargetFactory()));
        this.register(beanFactory, HttpSession.class, SpringExtUtil.createProxy(HttpSession.class, beanFactory.getBeanClassLoader(), new SessionProxyTargetFactory()));
        this.register(beanFactory, ServletResponse.class, SpringExtUtil.createProxy(HttpServletResponse.class, beanFactory.getBeanClassLoader(), new ResponseProxyTargetFactory()));
        RequestContextChainingService requestContexts = (RequestContextChainingService)beanFactory.getBean(this.requestContextsName, RequestContextChainingService.class);
        for (RequestContextInfo<?> info : requestContexts.getRequestContextInfos()) {
            Class<?> requestContextInterface = info.getRequestContextInterface();
            Class<?> requestContextProxyInterface = info.getRequestContextProxyInterface();
            if (RequestContext.class.equals(requestContextProxyInterface)) continue;
            this.register(beanFactory, requestContextInterface, SpringExtUtil.createProxy(requestContextProxyInterface, beanFactory.getBeanClassLoader(), new RequestContextProxyTargetFactory(requestContextProxyInterface)));
        }
    }

    private void register(ConfigurableListableBeanFactory beanFactory, Class<?> intfs, Object instance) {
        beanFactory.registerResolvableDependency(intfs, instance);
        log.debug("Registered Global Proxy for interface {}", (Object)intfs.getName());
    }

    private final class RequestContextProxyTargetFactory
    extends RequestProxyTargetFactory {
        private final Class<? extends RequestContext> requestContextInterface;

        private RequestContextProxyTargetFactory(Class<? extends RequestContext> requestContextInterface) {
            this.requestContextInterface = requestContextInterface;
        }

        @Override
        public Object getObject() {
            HttpServletRequest request = (HttpServletRequest)super.getObject();
            RequestContext requestContext = RequestContextUtil.findRequestContext(request, this.requestContextInterface);
            if (requestContext == null) {
                throw new IllegalStateException("Current request does not support request context: " + this.requestContextInterface.getName());
            }
            return requestContext;
        }
    }

    private final class SessionProxyTargetFactory
    extends RequestProxyTargetFactory {
        private SessionProxyTargetFactory() {
        }

        @Override
        public Object getObject() {
            HttpServletRequest request = (HttpServletRequest)super.getObject();
            RequestContext requestContext = RequestContextUtil.getRequestContext(request);
            if (requestContext == null) {
                throw new IllegalStateException("Current request does not support request context");
            }
            return requestContext.getRequest().getSession();
        }
    }

    private final class ResponseProxyTargetFactory
    extends RequestProxyTargetFactory {
        private ResponseProxyTargetFactory() {
        }

        @Override
        public Object getObject() {
            HttpServletRequest request = (HttpServletRequest)super.getObject();
            RequestContext requestContext = RequestContextUtil.getRequestContext(request);
            if (requestContext == null) {
                throw new IllegalStateException("Current request does not support request context");
            }
            return requestContext.getResponse();
        }
    }

    private static class RequestProxyTargetFactory
    implements ProxyTargetFactory {
        private RequestProxyTargetFactory() {
        }

        @Override
        public Object getObject() {
            RequestAttributes requestAttrs = RequestContextHolder.currentRequestAttributes();
            if (!(requestAttrs instanceof ServletRequestAttributes)) {
                throw new IllegalStateException("Current request is not a servlet request");
            }
            HttpServletRequest request = ((ServletRequestAttributes)requestAttrs).getRequest();
            if (request == null) {
                throw new IllegalStateException("Current request is not a servlet request");
            }
            return request;
        }
    }
}

