/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.basic.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.basic.CookieHeaderValueInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.CookieInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.CookieRejectedException;
import com.alibaba.citrus.service.requestcontext.basic.HeaderNameInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.HeaderValueInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.RedirectLocationInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.RedirectLocationRejectedException;
import com.alibaba.citrus.service.requestcontext.basic.RequestContextLifecycleInterceptor;
import com.alibaba.citrus.service.requestcontext.basic.ResponseHeaderRejectedException;
import com.alibaba.citrus.service.requestcontext.basic.StatusMessageInterceptor;
import com.alibaba.citrus.service.requestcontext.support.AbstractResponseWrapper;
import com.alibaba.citrus.service.requestcontext.util.CookieSupport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicResponseImpl
extends AbstractResponseWrapper {
    private static final String LOCATION_HEADER = "Location";
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private final Object[] interceptors;

    public BasicResponseImpl(RequestContext context, HttpServletResponse response, Object[] interceptors) {
        super(context, response);
        this.interceptors = interceptors == null ? new Object[0] : interceptors;
    }

    public void addDateHeader(String name, long date) {
        super.addDateHeader(this.checkHeaderName(name), date);
    }

    public void setDateHeader(String name, long date) {
        super.setDateHeader(this.checkHeaderName(name), date);
    }

    public void addIntHeader(String name, int value) {
        super.addIntHeader(this.checkHeaderName(name), value);
    }

    public void setIntHeader(String name, int value) {
        super.setIntHeader(this.checkHeaderName(name), value);
    }

    public void addHeader(String name, String value) {
        if (LOCATION_HEADER.equalsIgnoreCase(name = StringUtil.trimToNull(name))) {
            if ((value = this.checkRedirectLocation(value, false)) != null) {
                super.setHeader(LOCATION_HEADER, value);
            }
        } else if (SET_COOKIE_HEADER.equalsIgnoreCase(name)) {
            if ((value = this.checkCookieHeaderValue(name, value, false)) != null) {
                super.addHeader(SET_COOKIE_HEADER, value);
            }
        } else {
            value = this.checkHeaderValue(name = this.checkHeaderName(name), value);
            if (value != null) {
                super.addHeader(name, value);
            }
        }
    }

    public void setHeader(String name, String value) {
        if (LOCATION_HEADER.equalsIgnoreCase(name = StringUtil.trimToNull(name))) {
            if ((value = this.checkRedirectLocation(value, false)) != null) {
                super.setHeader(LOCATION_HEADER, value);
            }
        } else if (SET_COOKIE_HEADER.equalsIgnoreCase(name)) {
            if ((value = this.checkCookieHeaderValue(name, value, true)) != null) {
                super.setHeader(SET_COOKIE_HEADER, value);
            }
        } else {
            value = this.checkHeaderValue(name = this.checkHeaderName(name), value);
            if (value != null) {
                super.setHeader(name, value);
            }
        }
    }

    private String checkHeaderName(String name) throws ResponseHeaderRejectedException {
        Object interceptor;
        String newName = Assert.assertNotNull(name, "header name is null", new Object[0]);
        Object[] arr$ = this.interceptors;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (interceptor = arr$[i$]) instanceof HeaderNameInterceptor && (newName = ((HeaderNameInterceptor)interceptor).checkHeaderName(newName)) == null); ++i$) {
        }
        if (newName == null) {
            throw new ResponseHeaderRejectedException("HTTP header rejected: " + StringEscapeUtil.escapeJava(name));
        }
        return newName;
    }

    private String checkHeaderValue(String name, String value) throws ResponseHeaderRejectedException {
        Object interceptor;
        if (value == null) {
            return null;
        }
        String newValue = value;
        Object[] arr$ = this.interceptors;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (interceptor = arr$[i$]) instanceof HeaderValueInterceptor && (newValue = ((HeaderValueInterceptor)interceptor).checkHeaderValue(name, newValue)) == null); ++i$) {
        }
        if (newValue == null) {
            throw new ResponseHeaderRejectedException("HTTP header rejected: " + StringEscapeUtil.escapeJava(name) + "=" + StringEscapeUtil.escapeJava(value));
        }
        return newValue;
    }

    public void addCookie(Cookie cookie) {
        Cookie newCookie = this.checkCookie(cookie);
        CookieSupport newCookieSupport = newCookie instanceof CookieSupport ? (CookieSupport)newCookie : new CookieSupport(newCookie);
        newCookieSupport.addCookie((HttpServletResponse)this);
    }

    private Cookie checkCookie(Cookie cookie) throws CookieRejectedException {
        Object interceptor;
        Assert.assertNotNull(cookie, "no cookie", new Object[0]);
        Cookie newCookie = cookie;
        Object[] arr$ = this.interceptors;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (interceptor = arr$[i$]) instanceof CookieInterceptor && (newCookie = ((CookieInterceptor)interceptor).checkCookie(newCookie)) == null); ++i$) {
        }
        if (newCookie == null) {
            throw new CookieRejectedException("Cookie rejected: " + StringEscapeUtil.escapeJava(cookie.getName()) + "=" + StringEscapeUtil.escapeJava(cookie.getValue()));
        }
        return newCookie;
    }

    private String checkCookieHeaderValue(String name, String value, boolean setHeader) throws CookieRejectedException {
        Object interceptor;
        if (value == null) {
            return null;
        }
        String newValue = value;
        Object[] arr$ = this.interceptors;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (interceptor = arr$[i$]) instanceof CookieHeaderValueInterceptor && (newValue = ((CookieHeaderValueInterceptor)interceptor).checkCookieHeaderValue(name, newValue, setHeader)) == null); ++i$) {
        }
        if (newValue == null) {
            throw new CookieRejectedException("Set-Cookie rejected: " + StringEscapeUtil.escapeJava(value));
        }
        return newValue;
    }

    public void sendError(int sc, String msg) throws IOException {
        if ((msg = this.checkStatusMessage(sc, msg)) == null) {
            super.sendError(sc);
        } else {
            super.sendError(sc, msg);
        }
    }

    @Deprecated
    public void setStatus(int sc, String msg) {
        if ((msg = this.checkStatusMessage(sc, msg)) == null) {
            super.setStatus(sc);
        } else {
            super.setStatus(sc, msg);
        }
    }

    private String checkStatusMessage(int sc, String msg) {
        if (msg != null) {
            Object interceptor;
            Object[] arr$ = this.interceptors;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (interceptor = arr$[i$]) instanceof StatusMessageInterceptor && (msg = ((StatusMessageInterceptor)interceptor).checkStatusMessage(sc, msg)) == null); ++i$) {
            }
        }
        return msg;
    }

    public void sendRedirect(String location) throws IOException {
        super.sendRedirect(this.checkRedirectLocation(location, true));
    }

    private String checkRedirectLocation(String location, boolean notNull) throws RedirectLocationRejectedException {
        Object interceptor;
        String newLocation = StringUtil.trimToNull(location);
        if (newLocation == null && !notNull) {
            return null;
        }
        newLocation = BasicResponseImpl.normalizeLocation(newLocation, this.getRequestContext().getRequest());
        Object[] arr$ = this.interceptors;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || (interceptor = arr$[i$]) instanceof RedirectLocationInterceptor && (newLocation = ((RedirectLocationInterceptor)interceptor).checkRedirectLocation(newLocation)) == null); ++i$) {
        }
        if (newLocation == null) {
            throw new RedirectLocationRejectedException("Redirect location rejected: " + StringEscapeUtil.escapeJava(location));
        }
        return newLocation;
    }

    static String normalizeLocation(String location, HttpServletRequest request) {
        URI locationURI = URI.create(location = Assert.assertNotNull(StringUtil.trimToNull(location), "no redirect location", new Object[0]));
        if (!locationURI.isAbsolute()) {
            URI baseuri = URI.create(request.getRequestURL().toString());
            locationURI = baseuri.resolve(locationURI);
        }
        return locationURI.normalize().toString();
    }

    void prepareResponse() {
        for (Object interceptor : this.interceptors) {
            if (!(interceptor instanceof RequestContextLifecycleInterceptor)) continue;
            ((RequestContextLifecycleInterceptor)interceptor).prepare();
        }
    }

    void commitResponse() {
        for (int i = this.interceptors.length - 1; i >= 0; --i) {
            Object interceptor = this.interceptors[i];
            if (!(interceptor instanceof RequestContextLifecycleInterceptor)) continue;
            ((RequestContextLifecycleInterceptor)interceptor).commit();
        }
    }
}

