/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.adapter;

import com.alibaba.citrus.service.moduleloader.ActionEventException;
import com.alibaba.citrus.service.moduleloader.ActionEventNotFoundException;
import com.alibaba.citrus.service.moduleloader.impl.adapter.AbstractDataBindingAdapter;
import com.alibaba.citrus.service.moduleloader.impl.adapter.MethodInvoker;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.internal.ActionEventUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ActionEventAdapter
extends AbstractDataBindingAdapter
implements InitializingBean {
    private final Map<String, MethodInvoker> handlers;
    private final MethodInvoker preHandler;
    private final MethodInvoker postHandler;
    @Autowired
    private HttpServletRequest request;

    ActionEventAdapter(Object moduleObject, Map<String, MethodInvoker> handlers, MethodInvoker preHandler, MethodInvoker postHandler) {
        super(moduleObject);
        this.handlers = Assert.assertNotNull(handlers, "handlers", new Object[0]);
        this.preHandler = preHandler;
        this.postHandler = postHandler;
        Assert.assertTrue(!handlers.isEmpty(), "handlers", new Object[0]);
    }

    public void afterPropertiesSet() {
        SpringExtUtil.assertProxy(Assert.assertNotNull(this.request, "missing HttpServletRequest object", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ActionEventException, ActionEventNotFoundException {
        String event = ActionEventUtil.getEventName(this.request);
        MethodInvoker handler = null;
        if (event != null) {
            handler = this.handlers.get(event);
        }
        if (handler == null) {
            handler = this.handlers.get(null);
        }
        if (handler == null) {
            throw new ActionEventNotFoundException("Could not find handler method for action event: " + event);
        }
        if (this.preHandler != null) {
            this.log.debug("Invoking pre-action event handler for event {}: {}", (Object)event, (Object)this.preHandler);
            try {
                this.preHandler.invoke(this.moduleObject, this.log);
            }
            catch (Exception e) {
                throw new ActionEventException("Failed to execute pre-action event handler: " + this.preHandler, e);
            }
        }
        ActionEventException exception = null;
        try {
            this.log.debug("Invoking action event handler for event {}: {}", (Object)event, (Object)handler);
            try {
                handler.invoke(this.moduleObject, this.log);
            }
            catch (Exception e) {
                exception = new ActionEventException("Failed to execute action event handler: " + handler, e);
            }
        }
        finally {
            block18: {
                if (this.postHandler != null) {
                    this.log.debug("Invoking post-action event handler for event {}: {}", (Object)event, (Object)this.postHandler);
                    try {
                        this.postHandler.invoke(this.moduleObject, this.log);
                    }
                    catch (Exception e) {
                        if (exception != null) break block18;
                        exception = new ActionEventException("Failed to execute post-action event handler: " + this.postHandler, e);
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("moduleClass", this.moduleObject.getClass().getName());
        mb.append("handlers", new ToStringBuilder.MapBuilder().appendAll(this.handlers).setPrintCount(true).setSortKeys(true));
        mb.append("preHandler", this.preHandler);
        mb.append("postHandler", this.postHandler);
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

