/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.mail.MailNotFoundException;
import com.alibaba.citrus.service.mail.MailService;
import com.alibaba.citrus.service.mail.MailStoreNotFoundException;
import com.alibaba.citrus.service.mail.MailTransportNotFoundException;
import com.alibaba.citrus.service.mail.builder.MailBuilder;
import com.alibaba.citrus.service.mail.session.MailStore;
import com.alibaba.citrus.service.mail.session.MailTransport;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class MailServiceImpl
extends AbstractService<MailService>
implements MailService,
BeanFactoryAware {
    private final List<Object> importedServices = CollectionUtil.createLinkedList();
    private final Map<String, MailBuilder> mails = CollectionUtil.createHashMap();
    private final Map<String, MailStore> mailStores = CollectionUtil.createHashMap();
    private final Map<String, MailTransport> mailTransports = CollectionUtil.createHashMap();
    private BeanFactory factory;

    public void setBeanFactory(BeanFactory factory) {
        this.factory = Assert.assertNotNull(factory, "beanFactory", new Object[0]);
    }

    public void setImportedServices(Object[] services) {
        if (services != null) {
            this.importedServices.clear();
            for (Object service : services) {
                if (service == null) continue;
                this.importedServices.add(service);
            }
        }
    }

    public void setMails(Map<String, MailBuilder> mails) {
        if (mails != null) {
            this.mails.clear();
            this.mails.putAll(mails);
            for (Map.Entry<String, MailBuilder> entry : mails.entrySet()) {
                String mailId = Assert.assertNotNull(StringUtil.trimToNull(entry.getKey()), "mail id", new Object[0]);
                MailBuilder builder = Assert.assertNotNull(entry.getValue(), "mail builder", new Object[0]);
                builder.setId(mailId);
                builder.setMailService(this);
            }
        }
    }

    public void setMailStores(Map<String, MailStore> mailStores) {
        if (mailStores != null) {
            this.mailStores.clear();
            this.mailStores.putAll(mailStores);
            if (mailStores.size() == 1) {
                this.mailStores.put("_DEFAULT_", mailStores.values().iterator().next());
            } else {
                for (MailStore store : mailStores.values()) {
                    if (!store.isDefault()) continue;
                    Assert.assertTrue(!this.mailStores.containsKey("_DEFAULT_"), "more than 1 default stores", new Object[0]);
                    this.mailStores.put("_DEFAULT_", store);
                }
            }
            for (MailStore store : this.mailStores.values()) {
                store.setMailService(this);
            }
        }
    }

    public void setMailTransports(Map<String, MailTransport> mailTransports) {
        if (mailTransports != null) {
            this.mailTransports.clear();
            this.mailTransports.putAll(mailTransports);
            if (mailTransports.size() == 1) {
                this.mailTransports.put("_DEFAULT_", mailTransports.values().iterator().next());
            } else {
                for (MailTransport transport : mailTransports.values()) {
                    if (!transport.isDefault()) continue;
                    Assert.assertTrue(!this.mailTransports.containsKey("_DEFAULT_"), "more than 1 default transports", new Object[0]);
                    this.mailTransports.put("_DEFAULT_", transport);
                }
            }
            for (MailTransport transport : this.mailTransports.values()) {
                transport.setMailService(this);
            }
        }
    }

    @Override
    public <T> T getService(Class<T> serviceType, String defaultServiceId) {
        Assert.assertNotNull(serviceType, "serviceType", new Object[0]);
        for (Object service : this.importedServices) {
            if (!serviceType.isInstance(service)) continue;
            return serviceType.cast(service);
        }
        if (this.factory != null && defaultServiceId != null) {
            return serviceType.cast(this.factory.getBean(defaultServiceId, serviceType));
        }
        return null;
    }

    @Override
    public MailBuilder getMailBuilder(String id) throws MailNotFoundException {
        MailBuilder builder = this.mails.get(id = Assert.assertNotNull(StringUtil.trimToNull(id), "no mail id", new Object[0]));
        if (builder == null) {
            throw new MailNotFoundException("Could not find mail builder: " + id);
        }
        return builder.clone();
    }

    @Override
    public MailStore getMailStore() throws MailStoreNotFoundException {
        return this.getMailStore("_DEFAULT_", null);
    }

    @Override
    public MailStore getMailStore(Properties overrideProps) throws MailStoreNotFoundException {
        return this.getMailStore("_DEFAULT_", overrideProps);
    }

    @Override
    public MailStore getMailStore(String id) throws MailStoreNotFoundException {
        return this.getMailStore(id, null);
    }

    @Override
    public MailStore getMailStore(String id, Properties overrideProps) throws MailStoreNotFoundException {
        MailStore store = this.mailStores.get(id = Assert.assertNotNull(StringUtil.trimToNull(id), "no mailStore id", new Object[0]));
        if (store == null) {
            throw new MailStoreNotFoundException("Could not find mail store: " + id);
        }
        return new MailStore(store, overrideProps);
    }

    @Override
    public MailTransport getMailTransport() throws MailTransportNotFoundException {
        return this.getMailTransport("_DEFAULT_", null);
    }

    @Override
    public MailTransport getMailTransport(Properties overrideProps) throws MailTransportNotFoundException {
        return this.getMailTransport("_DEFAULT_", overrideProps);
    }

    @Override
    public MailTransport getMailTransport(String id) throws MailTransportNotFoundException {
        return this.getMailTransport(id, null);
    }

    @Override
    public MailTransport getMailTransport(String id, Properties overrideProps) throws MailTransportNotFoundException {
        MailTransport transport = this.mailTransports.get(id = Assert.assertNotNull(StringUtil.trimToNull(id), "no mailTransport id", new Object[0]));
        if (transport == null) {
            throw new MailTransportNotFoundException("Could not find mail transport: " + id);
        }
        return new MailTransport(transport, overrideProps);
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("mails", this.mails);
        mb.append("stores", this.mailStores);
        mb.append("transports", this.mailTransports);
        return new ToStringBuilder().append(this.getBeanDescription()).append(mb).toString();
    }
}

