/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.support;

import com.alibaba.citrus.service.form.MessageContext;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.impl.MessageContextFactory;
import com.alibaba.citrus.service.form.impl.ValidatorContextImpl;
import com.alibaba.citrus.service.form.support.AbstractValidator;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractCompositeValidator
extends AbstractValidator {
    private final List<Validator> validators = CollectionUtil.createLinkedList();
    private final List<Validator> validatorList = Collections.unmodifiableList(this.validators);

    public List<Validator> getValidators() {
        return this.validatorList;
    }

    public void setValidators(List<Validator> validators) {
        this.validators.clear();
        if (validators != null) {
            for (Validator validator : validators) {
                this.validators.add(Assert.assertNotNull(validator, "validator", new Object[0]));
            }
        }
    }

    @Override
    public void init(FieldConfig fieldConfig) throws Exception {
        super.init(fieldConfig);
        for (Validator validator : this.validators) {
            validator.init(fieldConfig);
        }
    }

    @Override
    public Validator clone() {
        AbstractCompositeValidator copy = (AbstractCompositeValidator)super.clone();
        ListIterator<Validator> i = copy.validators.listIterator();
        while (i.hasNext()) {
            i.set(i.next().clone());
        }
        return copy;
    }

    protected final Validator.Context newContext(Validator.Context context, Validator validator) {
        return this.newContext(context, validator, context.getValue());
    }

    protected final Validator.Context newContext(Validator.Context context, Validator validator, Object value) {
        MessageContext expressionContext = MessageContextFactory.newInstance(context.getField(), validator);
        expressionContext.copyLocalContext(context.getMessageContext());
        return new ValidatorContextImpl(expressionContext, context.getField(), value);
    }
}

