/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl;

import com.alibaba.citrus.service.configuration.support.PropertyEditorRegistrarsSupport;
import com.alibaba.citrus.service.form.impl.FormServiceImpl;
import com.alibaba.citrus.service.form.impl.configuration.FieldConfigImpl;
import com.alibaba.citrus.service.form.impl.configuration.FormConfigImpl;
import com.alibaba.citrus.service.form.impl.configuration.GroupConfigImpl;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class FormServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<FormServiceImpl>
implements ContributionAware {
    private ConfigurationPoint validatorConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.validatorConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/form/validators", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder formServiceBuilder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, formServiceBuilder);
        SpringExtUtil.addConstructorArg(formServiceBuilder, true, HttpServletRequest.class);
        BeanDefinitionBuilder formConfigBuilder = BeanDefinitionBuilder.genericBeanDefinition(FormConfigImpl.class);
        SpringExtUtil.attributesToProperties(element, formConfigBuilder, "converterQuiet", "postOnlyByDefault", "fieldKeyFormat", "messageCodePrefix");
        DomUtil.ElementSelector importSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("import"));
        List<Object> imports = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, importSelector)) {
            String formRef = Assert.assertNotNull(StringUtil.trimToNull(subElement.getAttribute("form")), "import form is empty", new Object[0]);
            imports.add(new RuntimeBeanReference(formRef));
        }
        formConfigBuilder.addPropertyValue("imports", imports);
        formConfigBuilder.addPropertyValue("propertyEditorRegistrars", PropertyEditorRegistrarsSupport.parseRegistrars(element, parserContext, formConfigBuilder));
        List<Object> groups = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("group")))) {
            groups.add(this.parseGroup(subElement, parserContext, formConfigBuilder));
        }
        formConfigBuilder.addPropertyValue("groupConfigImplList", groups);
        formServiceBuilder.addPropertyValue("formConfigImpl", (Object)formConfigBuilder.getBeanDefinition());
    }

    private Object parseGroup(Element element, ParserContext parserContext, BeanDefinitionBuilder formConfigBuilder) {
        BeanDefinitionBuilder groupConfigBuilder = BeanDefinitionBuilder.genericBeanDefinition(GroupConfigImpl.class);
        SpringExtUtil.attributesToProperties(element, groupConfigBuilder, "name", "trimmingByDefault", "postOnly");
        String parentGroup = StringUtil.trimToNull(element.getAttribute("extends"));
        if (parentGroup != null) {
            groupConfigBuilder.addPropertyValue("parentGroup", (Object)parentGroup);
        }
        DomUtil.ElementSelector importSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("import"));
        DomUtil.ElementSelector fieldSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("field"));
        List<Object> imports = SpringExtUtil.createManagedList(element, parserContext);
        List<Object> fields = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            if (importSelector.accept(subElement)) {
                imports.add(this.parseImportGroup(subElement, parserContext, groupConfigBuilder));
                continue;
            }
            if (!fieldSelector.accept(subElement)) continue;
            fields.add(this.parseField(subElement, parserContext, groupConfigBuilder));
        }
        groupConfigBuilder.addPropertyValue("imports", imports);
        groupConfigBuilder.addPropertyValue("fieldConfigImplList", fields);
        return groupConfigBuilder.getBeanDefinition();
    }

    private Object parseImportGroup(Element element, ParserContext parserContext, BeanDefinitionBuilder groupConfigBuilder) {
        BeanDefinitionBuilder importBuilder = BeanDefinitionBuilder.genericBeanDefinition(GroupConfigImpl.ImportImpl.class);
        importBuilder.addConstructorArgValue((Object)element.getAttribute("group"));
        importBuilder.addConstructorArgValue((Object)element.getAttribute("field"));
        return importBuilder.getBeanDefinition();
    }

    private Object parseField(Element element, ParserContext parserContext, BeanDefinitionBuilder groupConfigBuilder) {
        BeanDefinitionBuilder fieldConfigBuilder = BeanDefinitionBuilder.genericBeanDefinition(FieldConfigImpl.class);
        SpringExtUtil.attributesToProperties(element, fieldConfigBuilder, "name", "propertyName", "displayName", "trimming");
        String[] defaultValues = StringUtil.split(element.getAttribute("defaultValue"), ", ");
        fieldConfigBuilder.addPropertyValue("defaultValues", (Object)defaultValues);
        List<Object> validators = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder validator = SpringExtUtil.parseConfigurationPointBean(subElement, this.validatorConfigurationPoint, parserContext, fieldConfigBuilder);
            if (validator == null) continue;
            validators.add(validator);
        }
        fieldConfigBuilder.addPropertyValue("validators", validators);
        return fieldConfigBuilder.getBeanDefinition();
    }

    @Override
    protected String getDefaultName() {
        return "formService";
    }
}

