/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl.visitor;

import com.alibaba.citrus.dev.handler.impl.ExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.AbstractFallbackVisitor;
import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.ResourceTrace;
import com.alibaba.citrus.service.resource.ResourceTraceElement;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.IllegalPathException;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ResourcesVisitor
extends AbstractFallbackVisitor<ExplorerHandler.ExplorerVisitor> {
    private final ResourceLoadingService resourceLoadingService;
    private final String resourceName;
    private String title;
    private String content;
    private ResourceTraceElement traceElement;
    private Resource result;
    private List<String> subResourceNames;
    private String fullSubResourceName;
    private String relativeSubResourceName;
    private String pattern;

    public ResourcesVisitor(RequestHandlerContext context, ExplorerHandler.ExplorerVisitor v, ResourceLoadingService resourceLoadingService) {
        super(context, v);
        String resourceName;
        this.resourceLoadingService = Assert.assertNotNull(resourceLoadingService, "resourceLoadingService", new Object[0]);
        try {
            resourceName = StringUtil.defaultIfEmpty(FileUtil.normalizeAbsolutePath(context.getRequest().getParameter("resource")), "/");
        }
        catch (IllegalPathException e) {
            resourceName = "/";
        }
        this.resourceName = resourceName;
    }

    public void visitService(Template serviceNotAvailableTemplate, Template serviceTemplate) {
        if (this.resourceLoadingService == null) {
            serviceNotAvailableTemplate.accept(this);
        } else {
            serviceTemplate.accept(this);
        }
    }

    public void visitResourceName() {
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.resourceName));
    }

    public void visitTraceResource(Template traceResourceTemplate) {
        traceResourceTemplate.accept(this);
    }

    public void visitTrace(Template traceElementTemplate, Template resultTemplate, Template resultNotExistTemplate, Template resultNotFoundTemplate) {
        ResourceTrace trace = this.resourceLoadingService.trace(this.resourceName, ResourceLoadingService.FOR_CREATE);
        Iterator<ResourceTraceElement> i$ = trace.iterator();
        while (i$.hasNext()) {
            ResourceTraceElement traceElement;
            this.traceElement = traceElement = i$.next();
            traceElementTemplate.accept(this);
        }
        this.result = trace.getResult();
        if (this.result == null) {
            resultNotFoundTemplate.accept(this);
        } else if (!this.result.exists()) {
            resultNotExistTemplate.accept(this);
        } else {
            resultTemplate.accept(this);
        }
    }

    public void visitTrace(String param) {
        if ("resourceName".equals(param)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.traceElement.getResourceName()));
        } else if ("patternType".equals(param)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.traceElement.getPatternType()));
        } else if ("patternName".equals(param)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.traceElement.getPatternName()));
        } else if ("serviceName".equals(param)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.traceElement.getBeanName()));
        } else if ("serviceLocation".equals(param)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.traceElement.getConfigLocation()));
        } else if ("serviceLocationShort".equals(param)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.traceElement.getShortLocation()));
        } else {
            Assert.unreachableCode();
        }
    }

    public void visitInternal(Template internalTemplate) {
        if (this.traceElement.isInternalPattern()) {
            internalTemplate.accept(this);
        }
    }

    public void visitResult() {
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.result.toString()));
    }

    public void visitSubResources(Template subResourcesTemplate) {
        try {
            this.subResourceNames = CollectionUtil.createArrayList(this.resourceLoadingService.list(this.resourceName, ResourceLoadingService.FOR_CREATE));
        }
        catch (ResourceNotFoundException e) {
            this.subResourceNames = CollectionUtil.createArrayList();
        }
        Collections.sort(this.subResourceNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int d2;
                int d1 = o1.endsWith("/") ? 0 : 1;
                int n = d2 = o2.endsWith("/") ? 0 : 1;
                if (d1 == d2) {
                    return o1.compareTo(o2);
                }
                return d1 - d2;
            }
        });
        try {
            FileUtil.normalizeAbsolutePath(this.resourceName + "/..");
            this.subResourceNames.add(0, "..");
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        subResourcesTemplate.accept(this);
    }

    public void visitSubResource(Template subResourceTemplate) {
        for (String subResourceName : this.subResourceNames) {
            this.fullSubResourceName = FileUtil.normalizeAbsolutePath(this.resourceName + "/" + subResourceName);
            this.relativeSubResourceName = subResourceName;
            subResourceTemplate.accept(this);
        }
    }

    public void visitSubResourceName(String type) {
        if ("relative".equals(type)) {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.relativeSubResourceName));
        } else {
            ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.fullSubResourceName));
        }
    }

    public void visitPatterns(Template patternsTemplate) {
        patternsTemplate.accept(this);
    }

    public void visitPattern(Template patternTemplate) {
        String[] arr$ = this.resourceLoadingService.getPatterns(true);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String pattern;
            this.pattern = pattern = arr$[i$];
            patternTemplate.accept(this);
        }
    }

    public void visitPattern() {
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.pattern));
    }

    public void visitTitle() {
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.title));
    }

    public void visitBoxContent() {
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(this.content));
    }
}

