package cn.songxinqiang.weixin4j.response.model;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 回复图文消息的图文信息
 * @author 宋信强
 * @mail songxinqiang123@gmail.com
 * @datetime 2013年12月31日下午8:55:46
 * @version 
 */
public class Article {
	private String Title;
	private String Description;
	private String PicUrl;
	private String Url;

	/** 图文消息名称 */
	public String getTitle() {
		return Title;
	}

	/** 图文消息描述 */
	public String getDescription() {
		return Description;
	}

	/** 图片链接，支持JPG、PNG格式，较好的效果为大图640*320，小图80*80，限制图片链接的域名需要与开发者填写的基本资料中的Url一致 */
	public String getPicUrl() {
		return PicUrl;
	}

	/** 点击图文消息跳转链接 */
	public String getUrl() {
		return Url;
	}

	/** 图文消息名称 */
	public void setTitle(String title) {
		this.Title = title;
	}

	/** 图文消息描述 */
	public void setDescription(String description) {
		this.Description = description;
	}

	/** 图片链接，支持JPG、PNG格式，较好的效果为大图640*320，小图80*80，限制图片链接的域名需要与开发者填写的基本资料中的Url一致 */
	public void setPicUrl(String picUrl) {
		this.PicUrl = picUrl;
	}

	/** 点击图文消息跳转链接 */
	public void setUrl(String url) {
		this.Url = url;
	}

}
