package cn.songxinqiang.weixin4j.response;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 微信返回消息的类型
 * 
 * @author 宋信强
 * @email songxinqiang@vip.qq.com
 * @date 2014年4月5日
 */
public enum ResponseType {

	/**
	 * 返回消息类型：文本
	 */
	text("text"),
	/**
	 * 返回消息类型：图片
	 */
	image("image"),
	/**
	 * 返回消息类型：语音
	 */
	voice("voice"),
	/**
	 * 返回消息类型：视频
	 */
	video("video"),
	/**
	 * 返回消息类型：音乐
	 */
	music("music"),
	/**
	 * 返回消息类型：图文
	 */
	news("news");

	private String respType;

	ResponseType(String respType) {
		this.respType = respType;
	}

	@Override
	public String toString() {
		return respType;
	}

}
