package cn.songxinqiang.weixin4j.response;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.List;

import cn.songxinqiang.weixin4j.response.model.Article;

/**
 * 文本消息
 * 
 */
public class ResponseNewsMessage extends ResponseBaseMessage {
	private int ArticleCount;
	private List<Article> Articles;

	/** 图文消息个数，限制为10条以内 */
	public int getArticleCount() {
		return ArticleCount;
	}
	
	/** 多条图文消息信息，默认第一个item为大图 */
	public List<Article> getArticles() {
		return Articles;
	}

	/** 图文消息个数，限制为10条以内 */
	public void setArticleCount(int articleCount) {
		this.ArticleCount = articleCount;
	}

	/** 多条图文消息信息，默认第一个item为大图 */
	public void setArticles(List<Article> articles) {
		this.Articles = articles;
	}
}