package cn.songxinqiang.weixin4j.response;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 消息基类（公众帐号 -> 普通用户）
 * 
 */
public class ResponseBaseMessage {
	private String ToUserName;
	private String FromUserName;
	private long CreateTime;
	private ResponseType MsgType;
	private int FuncFlag;

	/** 接收方帐号（收到的OpenID） */
	public String getToUserName() {
		return ToUserName;
	}

	/** 开发者微信号 */
	public String getFromUserName() {
		return FromUserName;
	}

	/** 消息创建时间 （整型） */
	public long getCreateTime() {
		return CreateTime;
	}

	/** 消息类型（text/music/news） */
	public ResponseType getMsgType() {
		return MsgType;
	}

	/** 位0x0001被标志时，星标刚收到的消息 */
	public int getFuncFlag() {
		return FuncFlag;
	}

	/** 接收方帐号（收到的OpenID） */
	public void setToUserName(String toUserName) {
		this.ToUserName = toUserName;
	}

	/** 开发者微信号 */
	public void setFromUserName(String fromUserName) {
		this.FromUserName = fromUserName;
	}

	/** 消息创建时间 （整型） */
	public void setCreateTime(long createTime) {
		this.CreateTime = createTime;
	}

	/** 消息类型（text/music/news） */
	public void setMsgType(ResponseType msgType) {
		this.MsgType = msgType;
	}

	/** 位0x0001被标志时，星标刚收到的消息 */
	public void setFuncFlag(int funcFlag) {
		this.FuncFlag = funcFlag;
	}

}
