package cn.songxinqiang.weixin4j.request;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 上报地理位置事件<br>
 * 用户同意后，每次进入会话都会上传地理位置，或在进入会话后每5秒上报一次地理位置
 * 
 * @author 宋信强
 * @mail songxinqiang123@gmail.com
 * @datetime 2013年12月31日下午10:36:25
 * 
 * @version
 */
public class UploadLocationEvent extends EventBaseMessage {

	public static final String MSG_FIELD_Latitude = "Latitude";
	public static final String MSG_FIELD_Longitude = "Longitude";
	public static final String MSG_FIELD_Precision = "Precision";

	private String Latitude;
	private String Longitude;
	private String Precision;

	/** 纬度 */
	public String getLatitude() {
		return Latitude;
	}

	/** 经度 */
	public String getLongitude() {
		return Longitude;
	}

	/** 精确度 */
	public String getPrecision() {
		return Precision;
	}

	/** 纬度 */
	public void setLatitude(String latitude) {
		Latitude = latitude;
	}

	/** 经度 */
	public void setLongitude(String longitude) {
		Longitude = longitude;
	}

	/** 精确度 */
	public void setPrecision(String precision) {
		Precision = precision;
	}

}
