package cn.songxinqiang.weixin4j.request;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 微信请求消息的类型
 * 
 * @author 宋信强
 * @email songxinqiang@vip.qq.com
 * @date 2014年4月5日
 */
public enum RequestType {

	/**
	 * 请求消息类型：文本
	 */
	text("text"),
	/**
	 * 请求消息类型：图片
	 */
	image("image"),
	/**
	 * 请求消息类型：语音
	 */
	voice("voice"),
	/**
	 * 请求消息类型：视频
	 */
	video("video"),
	/**
	 * 请求消息类型：地理位置
	 */
	location("location"),
	/**
	 * 请求消息类型：链接
	 */
	link("link"),
	/**
	 * 请求消息类型：事件
	 */
	event("event");

	private String reqType;

	RequestType(String reqType) {
		this.reqType = reqType;
	}

	@Override
	public String toString() {
		return reqType;
	}
	
	public enum RequestEventType {

		/**
		 * 请求事件消息类型：事件->关注
		 */
		event_subscribe("subscribe"),
		/**
		 * 请求事件消息类型：事件->取消关注
		 */
		event_unsubscribe("unsubscribe"),
		/**
		 * 请求事件消息类型：事件->已关注扫描二维码
		 */
		event_scan("SCAN"),
		/**
		 * 请求事件消息类型：事件->上报地理位置
		 */
		event_location("LOCATION"),
		/**
		 * 请求事件消息类型：事件->点击自定义菜单
		 */
		event_click("CLICK"),
		/**
		 * 请求事件消息类型：事件->点击菜单跳转链接
		 */
		event_view("VIEW");

		private String eventType;

		RequestEventType(String eventType) {
			this.eventType = eventType;
		}

		@Override
		public String toString() {
			return eventType;
		}

	}

}
