package cn.songxinqiang.weixin4j.request;

/*
 * Copyright 2014 阿信(songxinqiang@vip.qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 消息基类（普通用户 -> 公众帐号）
 * 
 */
public class RequestBaseMessage {
	
	public static final String MSG_FIELD_ToUserName="ToUserName";
	public static final String MSG_FIELD_FromUserName="FromUserName";
	public static final String MSG_FIELD_CreateTime="CreateTime";
	public static final String MSG_FIELD_MsgType="MsgType";
	public static final String MSG_FIELD_MsgId="MsgId";
	
	private String ToUserName;
	private String FromUserName;
	private long CreateTime;
	private RequestType MsgType;
	private long MsgId;

	/** 开发者微信号 */
	public String getToUserName() {
		return ToUserName;
	}

	/** 发送方帐号（一个OpenID） */
	public String getFromUserName() {
		return FromUserName;
	}

	/** 消息创建时间 （毫秒数） */
	public long getCreateTime() {
		return CreateTime;
	}

	/** 消息类型（text/image/location/link） */
	public RequestType getMsgType() {
		return MsgType;
	}

	/** 消息id，64位整型 */
	public long getMsgId() {
		return MsgId;
	}

	/** 开发者微信号 */
	public void setToUserName(String toUserName) {
		this.ToUserName = toUserName;
	}

	/** 发送方帐号（一个OpenID） */
	public void setFromUserName(String fromUserName) {
		this.FromUserName = fromUserName;
	}

	/** 消息创建时间 （毫秒数） */
	public void setCreateTime(long createTime) {
		this.CreateTime = createTime;
	}

	/** 消息类型（text/image/location/link） */
	public void setMsgType(RequestType msgType) {
		this.MsgType = msgType;
	}

	/** 消息id，64位整型 */
	public void setMsgId(long msgId) {
		this.MsgId = msgId;
	}

}
