/*
 * Decompiled with CFR 0.152.
 */
package com.luway.pikachu.jobs;

import com.luway.pikachu.common.SnowFlakeUtil;
import com.luway.pikachu.core.engine.Pikachu;
import com.luway.pikachu.core.exception.SimpleException;
import com.luway.pikachu.core.worker.BathWorker;
import com.luway.pikachu.core.worker.GeneralWorker;
import com.luway.pikachu.core.worker.Worker;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PikachuJobManage {
    private ScheduledExecutorService taskPool;
    private Pikachu pikachu;
    private static final Logger logger = LoggerFactory.getLogger(PikachuJobManage.class);

    public PikachuJobManage(Pikachu pikachu) {
        this.pikachu = pikachu;
        this.taskPool = new ScheduledThreadPoolExecutor(2);
    }

    public boolean regiest(final Worker worker, Long startTime, Long space, TimeUnit unit) throws Exception {
        try {
            String id = SnowFlakeUtil.getId();
            logger.info("\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1\uff0cid\u4e3a\u3010{}}\u3011", (Object)id);
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (worker instanceof GeneralWorker) {
                        PikachuJobManage.this.pikachu.regist((GeneralWorker)worker);
                    }
                    if (worker instanceof BathWorker) {
                        PikachuJobManage.this.pikachu.regist((BathWorker)worker);
                    }
                }
            };
            this.taskPool.scheduleAtFixedRate(task, startTime, space, unit);
            return true;
        }
        catch (Exception e) {
            throw new Exception("regiest error", e);
        }
    }

    public boolean shutdown() {
        try {
            this.taskPool.shutdown();
        }
        catch (Exception e) {
            throw new SimpleException(e);
        }
        return true;
    }
}

