/*
 * Decompiled with CFR 0.152.
 */
package com.luway.pikachu.core.worker;

import com.luway.pikachu.core.annotations.CssPath;
import com.luway.pikachu.core.annotations.MathUrl;
import com.luway.pikachu.core.annotations.WorkerType;
import com.luway.pikachu.core.annotations.Xpath;
import com.luway.pikachu.core.exception.SimpleException;
import com.luway.pikachu.core.pipeline.BasePipeline;
import com.luway.pikachu.core.worker.Worker;
import com.luway.pikachu.core.worker.bean.BaseWorker;
import com.luway.pikachu.core.worker.bean.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralWorker
extends BaseWorker
implements Worker {
    private static final Logger log = LoggerFactory.getLogger(GeneralWorker.class);

    public GeneralWorker(String id, Class<?> bean) {
        this.id = id;
        super.setType(WorkerType.GENERAL);
        if (bean == null) {
            throw new RuntimeException("[error] class is null");
        }
        this.load(bean);
    }

    @Override
    public GeneralWorker cookies(Map<String, String> cookies) {
        super.setCookies(cookies);
        return this;
    }

    private GeneralWorker load(Class<?> bean) {
        MathUrl u = bean.getAnnotation(MathUrl.class);
        log.debug(bean.getName() + "is load");
        this.url = u.url();
        if (this.url == null) {
            throw new RuntimeException("[error] url can not be null");
        }
        super.setMethod(u.method());
        this.loadJs = u.loadJs();
        return this.attr(bean);
    }

    public GeneralWorker attr(Class<?> bean) {
        this.attr = new HashMap(16);
        try {
            Field[] fields;
            for (Field field : fields = bean.getDeclaredFields()) {
                boolean fieldHasXpath;
                boolean fieldHasAnno = field.isAnnotationPresent(CssPath.class);
                if (fieldHasAnno) {
                    CssPath cssPath = field.getAnnotation(CssPath.class);
                    Target t = new Target(field.getName(), field.getType().toString(), cssPath.selector(), null);
                    this.attr.put(field.getName(), t);
                    log.debug(field.getName() + ":" + field.getType().toString() + ":" + cssPath.selector());
                }
                if (!(fieldHasXpath = field.isAnnotationPresent(Xpath.class))) continue;
                Xpath xpath = field.getAnnotation(Xpath.class);
                Target t = new Target(field.getName(), field.getType().toString(), null, xpath.xpath());
                this.attr.put(field.getName(), t);
                log.debug(field.getName() + ":" + field.getType().toString() + ":" + xpath.xpath());
            }
        }
        catch (Exception e) {
            log.error("attr error", (Throwable)e);
            throw new SimpleException(e);
        }
        return this;
    }

    @Override
    public GeneralWorker addPipeline(BasePipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Override
    public Boolean validate() {
        if (this.pipeline == null) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "GeneralWorker{method=" + (Object)((Object)super.getMethod()) + ", id='" + this.id + '\'' + ", url='" + this.url + '\'' + ", attr=" + this.attr + ", cookies=" + super.getCookies() + ", pipeline=" + this.pipeline + ", loadJs=" + this.loadJs + '}';
    }
}

