/*
 * Decompiled with CFR 0.152.
 */
package com.luway.pikachu.core.engine.impl;

import com.luway.pikachu.core.annotations.MathUrl;
import com.luway.pikachu.core.engine.PiakchuPoolFactory;
import com.luway.pikachu.core.engine.Pikachu;
import com.luway.pikachu.core.engine.impl.PikachuCore;
import com.luway.pikachu.core.exception.SimpleException;
import com.luway.pikachu.core.worker.BathWorker;
import com.luway.pikachu.core.worker.GeneralWorker;
import com.luway.pikachu.core.worker.Worker;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PikachuImpl
implements Pikachu {
    private static final Logger logger = LoggerFactory.getLogger(PikachuImpl.class);
    private String name;
    private ExecutorService pikachuPool;
    private Integer maxThreadNum = 10;
    private Integer coreNum = 3;
    private PikachuCore core;

    public PikachuImpl(String name) {
        this.name = name;
    }

    @Override
    public PikachuImpl init() {
        if (this.pikachuPool == null) {
            this.pikachuPool = new ThreadPoolExecutor(this.coreNum, this.maxThreadNum, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), new PiakchuPoolFactory(this.name), new ThreadPoolExecutor.AbortPolicy());
        }
        if (this.core == null) {
            this.core = new PikachuCore(this.pikachuPool);
        }
        logger.debug("pikachu init ...");
        return this;
    }

    @Override
    public PikachuImpl regist(GeneralWorker worker) {
        if (null == worker) {
            throw new SimpleException("worker is null");
        }
        this.core.putWorker(worker);
        return this;
    }

    @Override
    public PikachuImpl regist(BathWorker worker) {
        if (null == worker) {
            throw new SimpleException("worker is null");
        }
        this.core.putWorker(worker);
        return this;
    }

    @Override
    public void start() {
        if (null == this.core) {
            throw new SimpleException("pikachu\u6838\u5fc3\u672a\u521d\u59cb\u5316,\u8bf7\u5148\u521d\u59cb\u5316\u5f15\u64ce");
        }
        this.core.start();
    }

    @Override
    public void stop() {
        logger.debug("pikachu stop ...");
        this.core.stop();
    }

    @Override
    public PikachuImpl setMaxThreadNum(Integer maxThreadNum) {
        this.maxThreadNum = maxThreadNum;
        return this;
    }

    @Override
    public PikachuImpl setCoreNum(Integer coreNum) {
        this.coreNum = coreNum;
        return this;
    }

    @Override
    public Queue<Worker> getQueue() {
        return this.core.getQueue();
    }

    @Override
    public Document getConnect(String url, MathUrl.Method method) throws IOException {
        return this.core.getConnect(url, method);
    }

    @Override
    public Document getConnect(String url, MathUrl.Method method, Map<String, String> cookies) throws IOException {
        return this.core.getConnect(url, method, cookies);
    }
}

